/* bluebox distributor
 * version 0.2 date 2006-11-29
 * Copyright (C) 2006 Stefan Schuermans <1stein@blinkenarea.org>
 * Copyleft: GNU public license V2.0 - http://www.gnu.org/copyleft/gpl.html
 * a BlinkenArea project - http://www.blinkenarea.org/
 */

#ifndef INC_bd_fmt
#define INC_bd_fmt

//structure for a pixel in a format
typedef struct s_bd_fmt_pix
{
  unsigned short dev_no; //number of the device the pixel is connected to
  unsigned short ser_no; //number of the serial port the pixel is connected to
  unsigned short pix_no; //number of the pixel at the serial port
  unsigned int out_buf_ofs; //offset into output buffer (pix_no * ser_cnt + ser_no)
  //all 4 numbers are set to -1 if pixel has to be ignored
  unsigned char sync_bit; //contains 0x80 if pix_no == 0, 0x00 otherwise
  unsigned char valid; //!= 0 if pixel is valid, == 0 if pixel has to be ignored
} st_bd_fmt_pix;

//structure for a format
typedef struct s_bd_fmt
{
  unsigned short width; //width of the format
  unsigned short height; //height of the format
  st_bd_fmt_pix * * pixels; //malloc-ed two-dimensional array with pixels (pixels[<height>][<width>])
} st_bd_fmt;

//load a format file
//returns pointer to malloc-ed st_bd_fmt structure on success, NULL on error
st_bd_fmt * bd_fmt_load( char * filename );

//free a format
void bd_fmt_free( st_bd_fmt * p_bd_fmt );

#endif //#ifndef INC_bd_config
