#!/usr/bin/perl -w

use strict;
use Capi;
use Time::HiRes qw(time usleep);
use IO::Select;

my $dad = shift
  || die "no destination address specified!\n";
my $bg = shift || '';
my $rec = shift || '';

my @files = ();
while($_=shift) {
  push @files, $_;
}

my $capi = Capi->new('00', '0', '49', '30')
  || die "no capi!\n";

warn "waiting for call on $dad\n";

my $sel = IO::Select->new(\*STDIN);
my $recording = 0;
my $rdata = '';

while(my $conn = $capi->wait_for_incoming_call) {

  my $oad = $conn->get_calling_party_number;
  defined($oad) && length($oad) or
    $oad = "<unknown>";

  warn "incoming call: oad: $oad, dad: "
    . $conn->get_called_party_number
      ."\n";

  $dad eq $conn->get_called_party_number or
    $conn->disco(1), next;

#  warn "alerting - press enter to accept\n";
#  $conn->call_proceeding;
#  $capi->do_work
#    until $sel->can_read(0.01);
#  <STDIN>;

  warn "accepting\n";
  $conn->accept;
  $conn->play_background($bg) if $bg;
  $conn->record($rec) if $rec;

  $conn->set_dtmf_callback(sub { shift;
				 my $dtmf = shift;
				 warn "received dtmf: $dtmf\n";
				 if($dtmf =~ /^\d$/ and $files[$dtmf]) {
				   warn "playing file: $files[$dtmf]\n";
				   $conn->play($files[$dtmf])
				 }
			       });

  my $oldtime = time;

  until($conn->get_state eq 'DISCONNECTED') {

    $capi->do_work;

    if(my $err = $conn->get_error) {
      warn "error: $err\n";
    }

    if(time - $oldtime > 1) {
      $oldtime = time;
      warn "still playing...\n" if $conn->is_playing;
    }

    usleep(1);
  }

  warn "disco!\n";

}
