/* blib - Library of useful things to hack the Blinkenlights
 *
 * Copyright (c) 2002-2007  The Blinkenlights Crew
 *                          Stefan Schuermans <1stein@blinkenarea.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <glib.h>

#include "characters.h"

static const ChFont ChFontNone =
  {
    width:        1,
    height:       1,
    advance:      1,
    line_advance: 1,
    chars:        "",
    unknown:      "1",
    data:         { }
  };

const ChFont *const pChFontNone = &ChFontNone; /* extern */

static const ChFont chfont_3x5 =
  {
    width:        3,
    height:       5,
    advance:      4,
    line_advance: 6,
    chars:        " 0123456789:.-+ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz",
    unknown: 
      "111"
      "111"
      "111"
      "111"
      "111",
    data:
      {
        /* space */
        "000"
        "000"
        "000"
        "000"
        "000",
        /* 0 */
        "111"
        "101"
        "101"
        "101"
        "111",
        /* 1 */
        "110"
        "010"
        "010"
        "010"
        "010",
        /* 2 */
        "011"
        "101"
        "001"
        "010"
        "111",
        /* 3 */
        "111"
        "001"
        "111"
        "001"
        "111",
        /* 4 */
        "101"
        "101"
        "111"
        "001"
        "001",
        /* 5 */
        "111"
        "100"
        "111"
        "001"
        "110",
        /* 6 */
        "111"
        "100"
        "111"
        "101"
        "111",
        /* 7 */
        "111"
        "001"
        "010"
        "100"
        "100",
        /* 8 */
        "111"
        "101"
        "111"
        "101"
        "111",
        /* 9 */
        "111"
        "101"
        "111"
        "001"
        "111",
        /* : */
        "000"
        "010"
        "000"
        "010"
        "000",
        /* . */
        "000"
        "000"
        "000"
        "000"
        "010",
        /* - */
        "000"
        "000"
        "111"
        "000"
        "000",
        /* + */
        "000"
        "010"
        "111"
        "010"
        "000",
        /* A */
        "111"
        "101"
        "111"
        "101"
        "101",
        /* B */
        "110"
        "101"
        "110"
        "101"
        "110",
        /* C */
        "111"
        "100"
        "100"
        "100"
        "111",
        /* D */
        "110"
        "101"
        "101"
        "101"
        "110",
        /* E */
        "111"
        "100"
        "110"
        "100"
        "111",
        /* F */
        "111"
        "100"
        "110"
        "100"
        "100",
        /* G */
        "111"
        "100"
        "101"
        "101"
        "111",
        /* H */
        "101"
        "101"
        "111"
        "101"
        "101",
        /* I */
        "010"
        "010"
        "010"
        "010"
        "010",
        /* J */
        "001"
        "001"
        "001"
        "101"
        "010",
        /* K */
        "101"
        "101"
        "110"
        "101"
        "101",
        /* L */
        "100"
        "100"
        "100"
        "100"
        "111",
        /* M */
        "101"
        "111"
        "101"
        "101"
        "101",
        /* N */
        "111"
        "101"
        "101"
        "101"
        "101",
        /* O */
        "010"
        "101"
        "101"
        "101"
        "010",
        /* P */
        "110"
        "101"
        "110"
        "100"
        "100",
        /* Q */
        "010"
        "101"
        "101"
        "101"
        "011",
        /* R */
        "110"
        "101"
        "110"
        "101"
        "101",
        /* S */
        "111"
        "100"
        "111"
        "001"
        "111",
        /* T */
        "111"
        "010"
        "010"
        "010"
        "010",
        /* U */
        "101"
        "101"
        "101"
        "101"
        "111",
        /* V */
        "101"
        "101"
        "101"
        "101"
        "010",
        /* W */
        "101"
        "101"
        "101"
        "111"
        "101",
        /* X */
        "101"
        "101"
        "010"
        "101"
        "101",
        /* Y */
        "101"
        "101"
        "010"
        "010"
        "010",
        /* Z */
        "111"
        "001"
        "010"
        "100"
        "111",
        /* a */
        "111"
        "101"
        "111"
        "101"
        "101",
        /* b */
        "110"
        "101"
        "110"
        "101"
        "110",
        /* c */
        "111"
        "100"
        "100"
        "100"
        "111",
        /* d */
        "110"
        "101"
        "101"
        "101"
        "110",
        /* e */
        "111"
        "100"
        "110"
        "100"
        "111",
        /* f */
        "111"
        "100"
        "110"
        "100"
        "100",
        /* g */
        "111"
        "100"
        "101"
        "101"
        "111",
        /* h */
        "101"
        "101"
        "111"
        "101"
        "101",
        /* i */
        "010"
        "010"
        "010"
        "010"
        "010",
        /* j */
        "001"
        "001"
        "001"
        "101"
        "010",
        /* k */
        "101"
        "101"
        "110"
        "101"
        "101",
        /* l */
        "100"
        "100"
        "100"
        "100"
        "111",
        /* m */
        "101"
        "111"
        "101"
        "101"
        "101",
        /* n */
        "111"
        "101"
        "101"
        "101"
        "101",
        /* o */
        "010"
        "101"
        "101"
        "101"
        "010",
        /* p */
        "110"
        "101"
        "110"
        "100"
        "100",
        /* q */
        "010"
        "101"
        "101"
        "101"
        "011",
        /* r */
        "110"
        "101"
        "110"
        "101"
        "101",
        /* s */
        "111"
        "100"
        "111"
        "001"
        "111",
        /* t */
        "111"
        "010"
        "010"
        "010"
        "010",
        /* u */
        "101"
        "101"
        "101"
        "101"
        "111",
        /* v */
        "101"
        "101"
        "101"
        "101"
        "010",
        /* w */
        "101"
        "101"
        "101"
        "111"
        "101",
        /* x */
        "101"
        "101"
        "010"
        "101"
        "101",
        /* y */
        "101"
        "101"
        "010"
        "010"
        "010",
        /* z */
        "111"
        "001"
        "010"
        "100"
        "111",
      }
  };

static const ChFont chfont_5x7 =
  {
    width:        5,
    height:       7,
    advance:      6,
    line_advance: 8,
    chars:        " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\x7F",
    unknown: 
      "11111"
      "11111"
      "11111"
      "11111"
      "11111"
      "11111"
      "11111",
    data:
      {
        /* space */
        "00000"
        "00000"
        "00000"
        "00000"
        "00000"
        "00000"
        "00000",
        /* ! */
        "00100"
        "00100"
        "00100"
        "00100"
        "00100"
        "00000"
        "00100",
        /* " */
        "01010"
        "01010"
        "01010"
        "00000"
        "00000"
        "00000"
        "00000",
        /* # */
        "01010"
        "01010"
        "11111"
        "01010"
        "11111"
        "01010"
        "01010",
        /* $ */
        "00100"
        "01111"
        "10100"
        "01110"
        "00101"
        "11110"
        "00100",
        /* % */
        "11000"
        "11001"
        "00010"
        "00100"
        "01000"
        "10011"
        "00011",
        /* & */
        "01100"
        "10010"
        "10100"
        "01000"
        "10101"
        "10010"
        "01101",
        /* ' */
        "01100"
        "00100"
        "01000"
        "00000"
        "00000"
        "00000"
        "00000",
        /* ( */
        "00010"
        "00100"
        "01000"
        "01000"
        "01000"
        "00100"
        "00010",
        /* ) */
        "01000"
        "00100"
        "00010"
        "00010"
        "00010"
        "00100"
        "01000",
        /* * */
        "00000"
        "00100"
        "10101"
        "01110"
        "10101"
        "00100"
        "00000",
        /* + */
        "00000"
        "00100"
        "00100"
        "11111"
        "00100"
        "00100"
        "00000",
        /* , */
        "00000"
        "00000"
        "00000"
        "00000"
        "01100"
        "00100"
        "01000",
        /* - */
        "00000"
        "00000"
        "00000"
        "11111"
        "00000"
        "00000"
        "00000",
        /* . */
        "00000"
        "00000"
        "00000"
        "00000"
        "00000"
        "01100"
        "01100",
        /* / */
        "00000"
        "00001"
        "00010"
        "00100"
        "01000"
        "10000"
        "00000",
        /* 0 */
        "01110"
        "10001"
        "10011"
        "10101"
        "11001"
        "10001"
        "01110",
        /* 1 */
        "00100"
        "01100"
        "00100"
        "00100"
        "00100"
        "00100"
        "01110",
        /* 2 */
        "01110"
        "10001"
        "00001"
        "00010"
        "00100"
        "01000"
        "11111",
        /* 3 */
        "11111"
        "00010"
        "00100"
        "00010"
        "00001"
        "10001"
        "01110",
        /* 4 */
        "00010"
        "00110"
        "01010"
        "10010"
        "11111"
        "00010"
        "00010",
        /* 5 */
        "11111"
        "10000"
        "11110"
        "00001"
        "00001"
        "10001"
        "01110",
        /* 6 */
        "00110"
        "01000"
        "10000"
        "11110"
        "10001"
        "10001"
        "01110",
        /* 7 */
        "11111"
        "00001"
        "00010"
        "00100"
        "01000"
        "01000"
        "01000",
        /* 8 */
        "01110"
        "10001"
        "10001"
        "01110"
        "10001"
        "10001"
        "01110",
        /* 9 */
        "01110"
        "10001"
        "10001"
        "01111"
        "00001"
        "00010"
        "01100",
        /* : */
        "00000"
        "01100"
        "01100"
        "00000"
        "01100"
        "01100"
        "00000",
        /* ; */
        "00000"
        "01100"
        "01100"
        "00000"
        "01100"
        "00100"
        "01000",
        /* < */
        "00010"
        "00100"
        "01000"
        "10000"
        "01000"
        "00100"
        "00010",
        /* = */
        "00000"
        "00000"
        "11111"
        "00000"
        "11111"
        "00000"
        "00000",
        /* > */
        "10000"
        "01000"
        "00100"
        "00010"
        "00100"
        "01000"
        "10000",
        /* ? */
        "01110"
        "10001"
        "00001"
        "00010"
        "00100"
        "00000"
        "00100",
        /* @ */
        "01110"
        "10001"
        "10001"
        "10111"
        "10111"
        "10000"
        "01110",
        /* A */
        "01110"
        "10001"
        "10001"
        "10001"
        "11111"
        "10001"
        "10001",
        /* B */
        "11110"
        "10001"
        "10001"
        "11110"
        "10001"
        "10001"
        "11110",
        /* C */
        "01110"
        "10001"
        "10000"
        "10000"
        "10000"
        "10001"
        "01110",
        /* D */
        "11110"
        "10001"
        "10001"
        "10001"
        "10001"
        "10001"
        "11110",
        /* E */
        "11111"
        "10000"
        "10000"
        "11110"
        "10000"
        "10000"
        "11111",
        /* F */
        "11111"
        "10000"
        "10000"
        "11110"
        "10000"
        "10000"
        "10000",
        /* G */
        "01110"
        "10001"
        "10000"
        "10111"
        "10001"
        "10001"
        "01111",
        /* H */
        "10001"
        "10001"
        "10001"
        "11111"
        "10001"
        "10001"
        "10001",
        /* I */
        "01110"
        "00100"
        "00100"
        "00100"
        "00100"
        "00100"
        "01110",
        /* J */
        "00111"
        "00010"
        "00010"
        "00010"
        "00010"
        "10010"
        "01100",
        /* K */
        "10001"
        "10010"
        "10100"
        "11000"
        "10100"
        "10010"
        "10001",
        /* L */
        "10000"
        "10000"
        "10000"
        "10000"
        "10000"
        "10000"
        "11111",
        /* M */
        "11011"
        "10101"
        "10001"
        "10001"
        "10001"
        "10001"
        "10001",
        /* N */
        "10001"
        "10001"
        "11001"
        "10101"
        "10011"
        "10001"
        "10001",
        /* O */
        "01110"
        "10001"
        "10001"
        "10001"
        "10001"
        "10001"
        "01110",
        /* P */
        "11110"
        "10001"
        "10001"
        "11110"
        "10000"
        "10000"
        "10000",
        /* Q */
        "01110"
        "10001"
        "10001"
        "10001"
        "10101"
        "10010"
        "01101",
        /* R */
        "11110"
        "10001"
        "10001"
        "11110"
        "10100"
        "10010"
        "10001",
        /* S */
        "01111"
        "10000"
        "10000"
        "01110"
        "00001"
        "00001"
        "11110",
        /* T */
        "11111"
        "00100"
        "00100"
        "00100"
        "00100"
        "00100"
        "00100",
        /* U */
        "10001"
        "10001"
        "10001"
        "10001"
        "10001"
        "10001"
        "01110",
        /* V */
        "10001"
        "10001"
        "10001"
        "10001"
        "10001"
        "01010"
        "00100",
        /* W */
        "10001"
        "10001"
        "10001"
        "10101"
        "10101"
        "10101"
        "01010",
        /* X */
        "10001"
        "10001"
        "01010"
        "00100"
        "01010"
        "10001"
        "10001",
        /* Y */
        "10001"
        "10001"
        "10001"
        "01010"
        "00100"
        "00100"
        "00100",
        /* Z */
        "11111"
        "00001"
        "00010"
        "00100"
        "01000"
        "10000"
        "11111",
        /* [ */
        "01110"
        "01000"
        "01000"
        "01000"
        "01000"
        "01000"
        "01110",
        /* \ */
        "00000"
        "10000"
        "01000"
        "00100"
        "00010"
        "00001"
        "00000",
        /* ] */
        "01110"
        "00010"
        "00010"
        "00010"
        "00010"
        "00010"
        "01110",
        /* ^ */
        "00100"
        "01010"
        "10001"
        "00000"
        "00000"
        "00000"
        "00000",
        /* _ */
        "00000"
        "00000"
        "00000"
        "00000"
        "00000"
        "00000"
        "11111",
        /* ` */
        "01000"
        "00100"
        "00010"
        "00000"
        "00000"
        "00000"
        "00000",
        /* a */
        "00000"
        "00000"
        "01110"
        "00001"
        "01111"
        "10001"
        "01111",
        /* b */
        "10000"
        "10000"
        "10110"
        "11001"
        "10001"
        "10001"
        "11110",
        /* c */
        "00000"
        "00000"
        "01111"
        "10000"
        "10000"
        "10000"
        "01111",
        /* d */
        "00001"
        "00001"
        "01101"
        "10011"
        "10001"
        "10001"
        "01111",
        /* e */
        "00000"
        "00000"
        "01110"
        "10001"
        "11111"
        "10000"
        "01110",
        /* f */
        "00110"
        "01001"
        "01000"
        "11100"
        "01000"
        "01000"
        "01000",
        /* g */
        "00000"
        "00000"
        "01111"
        "10001"
        "01111"
        "00001"
        "01110",
        /* h */
        "10000"
        "10000"
        "10110"
        "11001"
        "10001"
        "10001"
        "10001",
        /* i */
        "00100"
        "00000"
        "01100"
        "00100"
        "00100"
        "00100"
        "01110",
        /* j */
        "00010"
        "00000"
        "00110"
        "00010"
        "00010"
        "10010"
        "01100",
        /* k */
        "10000"
        "10000"
        "10010"
        "10100"
        "11000"
        "10100"
        "10010",
        /* l */
        "01100"
        "00100"
        "00100"
        "00100"
        "00100"
        "00100"
        "01110",
        /* m */
        "00000"
        "00000"
        "11010"
        "10101"
        "10101"
        "10001"
        "10001",
        /* n */
        "00000"
        "00000"
        "10110"
        "11001"
        "10001"
        "10001"
        "10001",
        /* o */
        "00000"
        "00000"
        "01110"
        "10001"
        "10001"
        "10001"
        "01110",
        /* p */
        "00000"
        "00000"
        "11110"
        "10001"
        "11110"
        "10000"
        "10000",
        /* q */
        "00000"
        "00000"
        "01111"
        "10001"
        "01111"
        "00001"
        "00001",
        /* r */
        "00000"
        "00000"
        "10110"
        "11001"
        "10000"
        "10000"
        "10000",
        /* s */
        "00000"
        "00000"
        "01111"
        "10000"
        "01110"
        "00001"
        "11110",
        /* t */
        "01000"
        "01000"
        "11110"
        "01000"
        "01000"
        "01001"
        "00110",
        /* u */
        "00000"
        "00000"
        "10001"
        "10001"
        "10001"
        "10011"
        "01101",
        /* v */
        "00000"
        "00000"
        "10001"
        "10001"
        "10001"
        "01010"
        "00100",
        /* w */
        "00000"
        "00000"
        "10001"
        "10001"
        "10101"
        "10101"
        "01010",
        /* x */
        "00000"
        "00000"
        "10001"
        "01010"
        "00100"
        "01010"
        "10001",
        /* y */
        "00000"
        "00000"
        "10001"
        "10001"
        "01111"
        "00001"
        "01110",
        /* z */
        "00000"
        "00000"
        "11111"
        "00010"
        "00100"
        "01000"
        "11111",
        /* { */
        "00010"
        "00100"
        "00100"
        "01000"
        "00100"
        "00100"
        "00010",
        /* | */
        "00100"
        "00100"
        "00100"
        "00100"
        "00100"
        "00100"
        "00100",
        /* } */
        "01000"
        "00100"
        "00100"
        "00010"
        "00100"
        "00100"
        "01000",
        /* ~ */
        "01101"
        "10110"
        "00000"
        "00000"
        "00000"
        "00000"
        "00000",
        /* delete */
        "00000"
        "00000"
        "00000"
        "00000"
        "00000"
        "00000"
        "00000",
      }
  };

static const ChFont chfont_5x7_wide =
  {
    width:        5,
    height:       7,
    advance:      9,
    line_advance: 8,
    chars:        " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\x7F",
    unknown: 
      "11111"
      "11111"
      "11111"
      "11111"
      "11111"
      "11111"
      "11111",
    data:
      {
        /* space */
        "00000"
        "00000"
        "00000"
        "00000"
        "00000"
        "00000"
        "00000",
        /* ! */
        "00100"
        "00100"
        "00100"
        "00100"
        "00100"
        "00000"
        "00100",
        /* " */
        "01010"
        "01010"
        "01010"
        "00000"
        "00000"
        "00000"
        "00000",
        /* # */
        "01010"
        "01010"
        "11111"
        "01010"
        "11111"
        "01010"
        "01010",
        /* $ */
        "00100"
        "01111"
        "10100"
        "01110"
        "00101"
        "11110"
        "00100",
        /* % */
        "11000"
        "11001"
        "00010"
        "00100"
        "01000"
        "10011"
        "00011",
        /* & */
        "01100"
        "10010"
        "10100"
        "01000"
        "10101"
        "10010"
        "01101",
        /* ' */
        "01100"
        "00100"
        "01000"
        "00000"
        "00000"
        "00000"
        "00000",
        /* ( */
        "00010"
        "00100"
        "01000"
        "01000"
        "01000"
        "00100"
        "00010",
        /* ) */
        "01000"
        "00100"
        "00010"
        "00010"
        "00010"
        "00100"
        "01000",
        /* * */
        "00000"
        "00100"
        "10101"
        "01110"
        "10101"
        "00100"
        "00000",
        /* + */
        "00000"
        "00100"
        "00100"
        "11111"
        "00100"
        "00100"
        "00000",
        /* , */
        "00000"
        "00000"
        "00000"
        "00000"
        "01100"
        "00100"
        "01000",
        /* - */
        "00000"
        "00000"
        "00000"
        "11111"
        "00000"
        "00000"
        "00000",
        /* . */
        "00000"
        "00000"
        "00000"
        "00000"
        "00000"
        "01100"
        "01100",
        /* / */
        "00000"
        "00001"
        "00010"
        "00100"
        "01000"
        "10000"
        "00000",
        /* 0 */
        "01110"
        "10001"
        "10011"
        "10101"
        "11001"
        "10001"
        "01110",
        /* 1 */
        "00100"
        "01100"
        "00100"
        "00100"
        "00100"
        "00100"
        "01110",
        /* 2 */
        "01110"
        "10001"
        "00001"
        "00010"
        "00100"
        "01000"
        "11111",
        /* 3 */
        "11111"
        "00010"
        "00100"
        "00010"
        "00001"
        "10001"
        "01110",
        /* 4 */
        "00010"
        "00110"
        "01010"
        "10010"
        "11111"
        "00010"
        "00010",
        /* 5 */
        "11111"
        "10000"
        "11110"
        "00001"
        "00001"
        "10001"
        "01110",
        /* 6 */
        "00110"
        "01000"
        "10000"
        "11110"
        "10001"
        "10001"
        "01110",
        /* 7 */
        "11111"
        "00001"
        "00010"
        "00100"
        "01000"
        "01000"
        "01000",
        /* 8 */
        "01110"
        "10001"
        "10001"
        "01110"
        "10001"
        "10001"
        "01110",
        /* 9 */
        "01110"
        "10001"
        "10001"
        "01111"
        "00001"
        "00010"
        "01100",
        /* : */
        "00000"
        "01100"
        "01100"
        "00000"
        "01100"
        "01100"
        "00000",
        /* ; */
        "00000"
        "01100"
        "01100"
        "00000"
        "01100"
        "00100"
        "01000",
        /* < */
        "00010"
        "00100"
        "01000"
        "10000"
        "01000"
        "00100"
        "00010",
        /* = */
        "00000"
        "00000"
        "11111"
        "00000"
        "11111"
        "00000"
        "00000",
        /* > */
        "10000"
        "01000"
        "00100"
        "00010"
        "00100"
        "01000"
        "10000",
        /* ? */
        "01110"
        "10001"
        "00001"
        "00010"
        "00100"
        "00000"
        "00100",
        /* @ */
        "01110"
        "10001"
        "10001"
        "10111"
        "10111"
        "10000"
        "01110",
        /* A */
        "01110"
        "10001"
        "10001"
        "10001"
        "11111"
        "10001"
        "10001",
        /* B */
        "11110"
        "10001"
        "10001"
        "11110"
        "10001"
        "10001"
        "11110",
        /* C */
        "01110"
        "10001"
        "10000"
        "10000"
        "10000"
        "10001"
        "01110",
        /* D */
        "11110"
        "10001"
        "10001"
        "10001"
        "10001"
        "10001"
        "11110",
        /* E */
        "11111"
        "10000"
        "10000"
        "11110"
        "10000"
        "10000"
        "11111",
        /* F */
        "11111"
        "10000"
        "10000"
        "11110"
        "10000"
        "10000"
        "10000",
        /* G */
        "01110"
        "10001"
        "10000"
        "10111"
        "10001"
        "10001"
        "01111",
        /* H */
        "10001"
        "10001"
        "10001"
        "11111"
        "10001"
        "10001"
        "10001",
        /* I */
        "01110"
        "00100"
        "00100"
        "00100"
        "00100"
        "00100"
        "01110",
        /* J */
        "00111"
        "00010"
        "00010"
        "00010"
        "00010"
        "10010"
        "01100",
        /* K */
        "10001"
        "10010"
        "10100"
        "11000"
        "10100"
        "10010"
        "10001",
        /* L */
        "10000"
        "10000"
        "10000"
        "10000"
        "10000"
        "10000"
        "11111",
        /* M */
        "11011"
        "10101"
        "10001"
        "10001"
        "10001"
        "10001"
        "10001",
        /* N */
        "10001"
        "10001"
        "11001"
        "10101"
        "10011"
        "10001"
        "10001",
        /* O */
        "01110"
        "10001"
        "10001"
        "10001"
        "10001"
        "10001"
        "01110",
        /* P */
        "11110"
        "10001"
        "10001"
        "11110"
        "10000"
        "10000"
        "10000",
        /* Q */
        "01110"
        "10001"
        "10001"
        "10001"
        "10101"
        "10010"
        "01101",
        /* R */
        "11110"
        "10001"
        "10001"
        "11110"
        "10100"
        "10010"
        "10001",
        /* S */
        "01111"
        "10000"
        "10000"
        "01110"
        "00001"
        "00001"
        "11110",
        /* T */
        "11111"
        "00100"
        "00100"
        "00100"
        "00100"
        "00100"
        "00100",
        /* U */
        "10001"
        "10001"
        "10001"
        "10001"
        "10001"
        "10001"
        "01110",
        /* V */
        "10001"
        "10001"
        "10001"
        "10001"
        "10001"
        "01010"
        "00100",
        /* W */
        "10001"
        "10001"
        "10001"
        "10101"
        "10101"
        "10101"
        "01010",
        /* X */
        "10001"
        "10001"
        "01010"
        "00100"
        "01010"
        "10001"
        "10001",
        /* Y */
        "10001"
        "10001"
        "10001"
        "01010"
        "00100"
        "00100"
        "00100",
        /* Z */
        "11111"
        "00001"
        "00010"
        "00100"
        "01000"
        "10000"
        "11111",
        /* [ */
        "01110"
        "01000"
        "01000"
        "01000"
        "01000"
        "01000"
        "01110",
        /* \ */
        "00000"
        "10000"
        "01000"
        "00100"
        "00010"
        "00001"
        "00000",
        /* ] */
        "01110"
        "00010"
        "00010"
        "00010"
        "00010"
        "00010"
        "01110",
        /* ^ */
        "00100"
        "01010"
        "10001"
        "00000"
        "00000"
        "00000"
        "00000",
        /* _ */
        "00000"
        "00000"
        "00000"
        "00000"
        "00000"
        "00000"
        "11111",
        /* ` */
        "01000"
        "00100"
        "00010"
        "00000"
        "00000"
        "00000"
        "00000",
        /* a */
        "00000"
        "00000"
        "01110"
        "00001"
        "01111"
        "10001"
        "01111",
        /* b */
        "10000"
        "10000"
        "10110"
        "11001"
        "10001"
        "10001"
        "11110",
        /* c */
        "00000"
        "00000"
        "01111"
        "10000"
        "10000"
        "10000"
        "01111",
        /* d */
        "00001"
        "00001"
        "01101"
        "10011"
        "10001"
        "10001"
        "01111",
        /* e */
        "00000"
        "00000"
        "01110"
        "10001"
        "11111"
        "10000"
        "01110",
        /* f */
        "00110"
        "01001"
        "01000"
        "11100"
        "01000"
        "01000"
        "01000",
        /* g */
        "00000"
        "00000"
        "01111"
        "10001"
        "01111"
        "00001"
        "01110",
        /* h */
        "10000"
        "10000"
        "10110"
        "11001"
        "10001"
        "10001"
        "10001",
        /* i */
        "00100"
        "00000"
        "01100"
        "00100"
        "00100"
        "00100"
        "01110",
        /* j */
        "00010"
        "00000"
        "00110"
        "00010"
        "00010"
        "10010"
        "01100",
        /* k */
        "10000"
        "10000"
        "10010"
        "10100"
        "11000"
        "10100"
        "10010",
        /* l */
        "01100"
        "00100"
        "00100"
        "00100"
        "00100"
        "00100"
        "01110",
        /* m */
        "00000"
        "00000"
        "11010"
        "10101"
        "10101"
        "10001"
        "10001",
        /* n */
        "00000"
        "00000"
        "10110"
        "11001"
        "10001"
        "10001"
        "10001",
        /* o */
        "00000"
        "00000"
        "01110"
        "10001"
        "10001"
        "10001"
        "01110",
        /* p */
        "00000"
        "00000"
        "11110"
        "10001"
        "11110"
        "10000"
        "10000",
        /* q */
        "00000"
        "00000"
        "01111"
        "10001"
        "01111"
        "00001"
        "00001",
        /* r */
        "00000"
        "00000"
        "10110"
        "11001"
        "10000"
        "10000"
        "10000",
        /* s */
        "00000"
        "00000"
        "01111"
        "10000"
        "01110"
        "00001"
        "11110",
        /* t */
        "01000"
        "01000"
        "11110"
        "01000"
        "01000"
        "01001"
        "00110",
        /* u */
        "00000"
        "00000"
        "10001"
        "10001"
        "10001"
        "10011"
        "01101",
        /* v */
        "00000"
        "00000"
        "10001"
        "10001"
        "10001"
        "01010"
        "00100",
        /* w */
        "00000"
        "00000"
        "10001"
        "10001"
        "10101"
        "10101"
        "01010",
        /* x */
        "00000"
        "00000"
        "10001"
        "01010"
        "00100"
        "01010"
        "10001",
        /* y */
        "00000"
        "00000"
        "10001"
        "10001"
        "01111"
        "00001"
        "01110",
        /* z */
        "00000"
        "00000"
        "11111"
        "00010"
        "00100"
        "01000"
        "11111",
        /* { */
        "00010"
        "00100"
        "00100"
        "01000"
        "00100"
        "00100"
        "00010",
        /* | */
        "00100"
        "00100"
        "00100"
        "00100"
        "00100"
        "00100"
        "00100",
        /* } */
        "01000"
        "00100"
        "00100"
        "00010"
        "00100"
        "00100"
        "01000",
        /* ~ */
        "01101"
        "10110"
        "00000"
        "00000"
        "00000"
        "00000"
        "00000",
        /* delete */
        "00000"
        "00000"
        "00000"
        "00000"
        "00000"
        "00000"
        "00000",
      }
  };

const ChFont *fontList[] =
  {
    &chfont_3x5,
    &chfont_5x7,
    &chfont_5x7_wide,
  };

/* select a font */
const ChFont *selectChFont (guint chars, guint lines,
                            guint max_width, guint max_height)
{
  /* search font meeting criteria */
  gint i;
  for (i = sizeof (fontList) / sizeof (fontList[0]) - 1;
       i >= 0; i--)
    {
      /* check width */
      if ((chars < 1
           || (chars - 1) * fontList[i]->advance
              + fontList[i]->width <= max_width) &&
          (lines < 1
           || (lines - 1) * fontList[i]->line_advance
              + fontList[i]->height <= max_height))
        /* return font */
        return fontList[i];
    }
  /* no font found */
  return &ChFontNone;
}

/* get a character from a font */
const char *getChFontChar (const ChFont *font, char chr)
{
  /* search character */
  gint i;
  for (i = 0; font->chars[i] != 0; i++)
    if (font->chars[i] == chr)
      /* return charcter */
      return font->data[i];
  /* character not found-> return unknwon character */
  return font->unknown;
}

