/* BLINKENLIGHTS PROXY
 * version 0.99 date 2006-11-29
 * Copyright (C) 2003-2006 Stefan Schuermans <1stein@schuermans.info>
 * Copyleft: GNU public license - http://www.gnu.org/copyleft/gpl.html
 */

#ifndef INC_dynsrc
#define INC_dynsrc

//type for data of dynamic source list items
typedef struct s_dynsrc_data st_dynsrc_data;

//type for a dynamic source list
typedef struct s_dynsrc_list st_dynsrc_list;

#include "output.h"

//create a new dynamic source list
//<af> specifies the address family of this dynamic source list (obtained from owning port)
//returns the pointer to the list or NULL in case of error
st_dynsrc_list * dynsrc_new( int af, st_out_info * p_out_info );

//free a dynamic source list
void dynsrc_free( st_dynsrc_list * p_dynsrc_list );

//add a dynamic source to a dynamic source list
//returns 0 on success, a negative value in case of error
int dynsrc_add( st_dynsrc_list * p_dynsrc_list, char * p_name, char * p_addr, char * p_proto, char * p_interval, int sock, st_out_info * p_out_info );

//delete a dynamic source from a dynamic source list
//returns 0 on success, a negative value in case of error
int dynsrc_del( st_dynsrc_list * p_dynsrc_list, char * p_name, int sock, st_out_info * p_out_info );

//list dynamic sources in a dynamic source list
void dynsrc_list( st_dynsrc_list * p_dynsrc_list, st_out_info * p_out_info );

//do periodic tasks for dynamic sources
void dynsrc_tick( st_dynsrc_list * p_dynsrc_list, int sock );

#endif //#ifndef INC_dynsrc
