/* BLINKENLIGHTS PROXY
 * version 0.98 date 2006-07-27
 * Copyright (C) 2003-2006 Stefan Schuermans <1stein@schuermans.info>
 * Copyleft: GNU public license - http://www.gnu.org/copyleft/gpl.html
 */

#ifndef INC_infilter
#define INC_infilter

//type for data of input filter list items
typedef struct s_infilter_data st_infilter_data;

//type for a input filter list
typedef struct s_infilter_list st_infilter_list;

#include "output.h"
#include "proto.h"

//create a new input filter list
//<af> specifies the address family of this input filter list (obtained from owning port)
//returns the pointer to the list or NULL in case of error
st_infilter_list * infilter_new( int af, st_out_info * p_out_info );

//free a input filter list
void infilter_free( st_infilter_list * p_infilter_list );

//add a input filter rule to a input filter list
//returns 0 on success, a negative value in case of error
int infilter_add( st_infilter_list * p_infilter_list, char * p_index, char * p_range, char * p_proto, char * p_format, char * p_name, char stop, char * p_op_name, char * p_priority, char * p_timeout, st_out_info * p_out_info );

//delete a input filter rule from a input filter list
//returns 0 on success, a negative value in case of error
int infilter_del( st_infilter_list * p_infilter_list, char * p_index, st_out_info * p_out_info );

//list input filter rules in a input filter list
void infilter_list( st_infilter_list * p_infilter_list, st_out_info * p_out_info );

//pass frame along input filter list
void infilter_process( st_infilter_list * p_infilter_list, st_frame * p_frame );

#endif //#ifndef INC_infilter
