/* BLINKENLIGHTS PROXY
 * version 0.98 date 2006-07-27
 * Copyright (C) 2003-2006 Stefan Schuermans <1stein@schuermans.info>
 * Copyleft: GNU public license - http://www.gnu.org/copyleft/gpl.html
 */

#ifndef INC_addr_list
#define INC_addr_list

//type for an address list
typedef struct s_addr_list st_addr_list;

#include "addr.h"

//create a new address list
//returns NULL in case of error
st_addr_list * addr_list_new( );

//delete an address list (including all entries)
//data_free_func is called for the data of every list item (if not NULL)
void addr_list_free( st_addr_list * p_addr_list, void (*data_free_func)( void * ) );

//add an item to an address list
//returns 0 on success, a negative value on error
int addr_list_add( st_addr_list * p_addr_list, st_addr * p_src_addr, st_addr * p_dest_addr, void * p_data );

//delete an item from an address list
//data_free_func is called for the data of deleted list item (if not NULL)
//returns 0 on success, a negative value on error
int addr_list_del( st_addr_list * p_addr_list, st_addr * p_src_addr, st_addr * p_dest_addr, void (*data_free_func)( void * ) );

//get the data of an item in an address list
//returns the data pointer of NULL on error
void * addr_list_get( st_addr_list * p_addr_list, st_addr * p_src_addr, st_addr * p_dest_addr );

//enumerate all items in an address list
//the enumerations stops when enum_func retuns a value != 0
void addr_list_enum( st_addr_list * p_addr_list, int (*enum_func)( st_addr *, st_addr *, void *, void * ), void * p_enum_context );

//delete some items in an address list by enumerating
//the entry is delted from the list if enum_func retuns a value != 0
void addr_list_enum_del( st_addr_list * p_addr_list, int (*enum_func)( st_addr *, st_addr *, void *, void * ), void * p_enum_context, void (*data_free_func)( void * ) );

#endif //#ifndef INC_addr_list
