/* BLINKENLIGHTS PROXY
 * version 0.98 date 2006-07-27
 * Copyright (C) 2003-2006 Stefan Schuermans <1stein@schuermans.info>
 * Copyleft: GNU public license - http://www.gnu.org/copyleft/gpl.html
 */

#ifndef INC_addr
#define INC_addr

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

//type for addresses
typedef struct s_addr st_addr;

//type for address range
typedef struct s_addr_range st_addr_range;

#include "output.h"

//type for addresses (see above)
struct s_addr
{
  int af; //address family
  socklen_t sa_len; //length of sockaddr e.g. as expected by bind
  union //the sockaddr
  {
    struct sockaddr sa;
    struct sockaddr_in sin;
    struct sockaddr_in6 sin6;
  } sa;
};

//type for address range (see above)
struct s_addr_range
{
  int af; //address family
  union
  {
    struct //IPv4
    {
      struct in_addr net; //network range
      struct in_addr mask;
      in_port_t port_min; //port range
      in_port_t port_max;
    } in;
    struct //IPv6
    {
      struct in6_addr net; //network range
      struct in6_addr mask;
      in_port_t port_min; //port range
      in_port_t port_max;
    } in6;
  } range;
};

//read address from string
//address consists of 3 strings <address family> <host> <port>
//returns 0 on success, a negative value on error
int addr_str2addr( char * p_str, st_addr * p_addr, st_out_info * p_out_info );

//set up addr structure from sa and sa_len members
//returns 0 on success, a negative value on error
int addr_sa2addr( st_addr * p_addr );

//get string from address
//address consists of 3 strings <address family> <host> <port>
//returns 0 on success, a negative value on error
int addr_addr2str( st_addr * p_addr, char * p_str, unsigned int str_buf_size, st_out_info * p_out_info );

//output address
//address consists of 3 strings <address family> <host> <port>
void addr_addr_out( st_addr * p_addr, st_out_info * p_out_info );

//compare addresses (e.g. used to sort lists)
int addr_cmp( st_addr * p_addr1, st_addr * p_addr2 );

//read address range from string
//address range consists of 3 strings <address family> <net/mask> <port-port>
//returns 0 on success, a negative value on error
int addr_str2range( char * p_str, st_addr_range * p_range, st_out_info * p_out_info );

//get string from address range
//address range consists of 3 strings <address family> <net/mask> <port-port>
//returns 0 on success, a negative value on error
int addr_range2str( st_addr_range * p_range, char * p_str, unsigned int str_buf_size, st_out_info * p_out_info );

//output address range
//address range consists of 3 strings <address family> <net/mask> <port-port>
void addr_range_out( st_addr_range * p_range, st_out_info * p_out_info );

//check if an addr matches an address range
//retuns 1 on match, 0 on mismatch
int addr_match( st_addr * p_addr, st_addr_range * p_range );

#endif //#ifndef INC_addr
