/* BLINKENLIGHTS PROXY
 * version 0.97 date 2005-12-29
 * Copyright (C) 2003-2005 Stefan Schuermans <1stein@schuermans.info>
 * Copyleft: GNU public license - http://www.gnu.org/copyleft/gpl.html
 */

#include "tools.h"

//get first <cnt> words and rest of a string
void tools_str_first_words( char * p_str, unsigned int cnt, char * * pp_first, char * * pp_rest )
{
  unsigned int i;

  //jump over whitespaces
  while( *p_str == '\t' || *p_str == ' ' )
    p_str++;

  //first <cnt> words start here
  *pp_first = p_str;

  //jump over first <cnt> words
  for( i = 0; i < cnt; i++ )
  {
    //jump over next word
    while( *p_str != 0 && *p_str != '\t' && *p_str != ' ' )
      p_str++;

    //first <cnt> words end here if in last turn of loop
    if( i + 1 == cnt && *p_str != 0 )
    {
      *p_str = 0;
      p_str++;
    }

    //jump over whitespaces
    while( *p_str == '\t' || *p_str == ' ' )
      p_str++;
  } //for( i = 0; i < cnt; i++ )

  //rest starts here
  *pp_rest = p_str;
}
