/* BLINKENLIGHTS PROXY
 * version 0.97 date 2005-12-29
 * Copyright (C) 2003-2005 Stefan Schuermans <1stein@schuermans.info>
 * Copyleft: GNU public license - http://www.gnu.org/copyleft/gpl.html
 */

#ifndef INC_outfilter
#define INC_outfilter

//type for an output filter list
typedef struct s_outfilter_list st_outfilter_list;

//type for data of output filter list items
typedef struct s_outfilter_data st_outfilter_data;

#include "addr.h"
#include "outport.h"
#include "output.h"
#include "proto.h"

//create a new output filter list
//<af> specifies the address family of this output filter list (obtained from owning port)
//returns the pointer to the list or NULL in case of error
st_outfilter_list * outfilter_new( int af, st_out_info * p_out_info, st_outport_data * p_outport_data );

//free an output filter list
void outfilter_free( st_outfilter_list * p_outfilter_list );

//add an output filter rule to a output filter list
//returns 0 on success, a negative value in case of error
int outfilter_add( st_outfilter_list * p_outfilter_list, char * p_index, char * p_range, char * p_proto, char * p_name, char deny, char * p_timeout, char * p_format, st_out_info * p_out_info );

//delete an output filter rule from a output filter list
//returns 0 on success, a negative value in case of error
int outfilter_del( st_outfilter_list * p_outfilter_list, char * p_index, st_out_info * p_out_info );

//list output filter rules in a output filter list
void outfilter_list( st_outfilter_list * p_outfilter_list, st_out_info * p_out_info );

//pass request along input filter list
void outfilter_process( st_outfilter_list * p_outfilter_list, st_addr * p_addr, et_proto proto, int enable );

#endif //#ifndef INC_outfilter
