/* BLINKENLIGHTS PROXY
 * version 0.97 date 2005-12-29
 * Copyright (C) 2003-2005 Stefan Schuermans <1stein@schuermans.info>
 * Copyleft: GNU public license - http://www.gnu.org/copyleft/gpl.html
 */

#ifndef INC_dyndest
#define INC_dyndest

//type for data of dynamic destination list items
typedef struct s_dyndest_data st_dyndest_data;

//type for a dynamic destination list
typedef struct s_dyndest_list st_dyndest_list;

#include "addr.h"
#include "outport.h"
#include "output.h"
#include "proto.h"

//create a new dynamic destination list
//returns the pointer to the list or NULL in case of error
st_dyndest_list * dyndest_new( st_outport_data * p_outport_data, st_out_info * p_out_info );

//free a dynamic destination list
void dyndest_free( st_dyndest_list * p_dyndest_list );

//add a dynamic destination
//returns 0 on success, a negative value in case of error
int dyndest_add( st_dyndest_list * p_dyndest_list, st_addr * p_src_addr, st_addr * p_dest_addr, char * p_name, et_proto proto, st_format * p_format, unsigned short timeout );

//remove a dynamic destination
//returns 0 on success, a negative value in case of error
int dyndest_del( st_dyndest_list * p_dyndest_list, st_addr * p_src_addr, st_addr * p_dest_addr );

//list dynamic destinations in a dynamic destination list
void dyndest_list( st_dyndest_list * p_dyndest_list, st_out_info * p_out_info );

//do periodic work for a dynamic destination list
void dyndest_tick( st_dyndest_list * p_dyndest_list );

//send a frame to dynamic destinations
void dyndest_send_frame( st_dyndest_list * p_dyndest_list, st_frame * p_frame, int sock );

#endif //#ifndef INC_dyndest
