/* BLINKENLIGHTS PROXY
 * version 0.96 date 2005-01-27
 * Copyright (C) 2003-2005 Stefan Schuermans <1stein@schuermans.info>
 * Copyleft: GNU public license - http://www.gnu.org/copyleft/gpl.html
 */

#ifndef INC_list
#define INC_list

//length of the buffers for names of list items
// - i.e. all names are truncated after <list_item_name_size>-1 characters
#define list_item_name_size 64

//type for a list
typedef struct s_list st_list;

//create a new list
//returns NULL in case of error
st_list * list_new( );

//delete a list (including all entries)
//data_free_func is called for the data of every list item (if not NULL)
void list_free( st_list * p_list, void (*data_free_func)( void * ) );

//add an item to a list
//returns 0 on success, a negative value on error
int list_add( st_list * p_list, char * name, void * p_data );

//delete an item from a list
//data_free_func is called for the data of deleted list item (if not NULL)
//returns 0 on success, a negative value on error
int list_del( st_list * p_list, char * name, void (*data_free_func)( void * ) );

//get the data of an item in a list
//returns the data pointer of NULL on error
void * list_get( st_list * p_list, char * name );

//enumerate all items in a list
//the enumerations stops when enum_func retuns a value != 0
void list_enum( st_list * p_list, int (*enum_func)( char *, void *, void * ), void * p_enum_context );

#endif //#ifndef INC_list
