/* BLINKENLIGHTS PROXY
 * version 0.96 date 2005-01-27
 * Copyright (C) 2003-2005 Stefan Schuermans <1stein@schuermans.info>
 * Copyleft: GNU public license - http://www.gnu.org/copyleft/gpl.html
 */

#include <stdio.h>
#include <errno.h>
#include <sys/time.h>

#include "inport.h"
#include "outport.h"
#include "output.h"
#include "global.h"

//input port list
st_inport_list * p_global_inport_list; //(extern)

//output port list
st_outport_list * p_global_outport_list; //(extern)

//number of milliseconds since start of the program (wraps around!)
unsigned long global_millisecs; //(extern)
//reference time to calculate number od milliseconds
struct timeval global_millisecs_tv;

//initialize global stuff
//returns 0 on success, a negative value on error
int global_init( st_out_info * p_out_info )
{
  //create input port list
  p_global_inport_list = inport_new( p_out_info );
  if( p_global_inport_list == NULL )
  {
    out_str( p_out_info, "  error: could not create input port list (out of memory)\n" );
    return -ENOMEM;
  }

  //create output port list
  p_global_outport_list = outport_new( p_out_info );
  if( p_global_outport_list == NULL )
  {
    inport_free( p_global_inport_list );
    out_str( p_out_info, "  error: could not create output port list (out of memory)\n" );
    return -ENOMEM;
  }

  //initialize milliseconds since start of the program
  global_millisecs = 0;
  gettimeofday( &global_millisecs_tv, NULL );

  return 0;
}

//cleanup global stuff
void global_exit( )
{
  //free input port list
  inport_free( p_global_inport_list );

  //free output port list
  outport_free( p_global_outport_list );
}

//do periodic global tasks
void global_tick( )
{
  struct timeval current_time;
  long ms;

  //update number of milliseconds since start of the program
  gettimeofday( &current_time, NULL );
  ms = (current_time.tv_sec - global_millisecs_tv.tv_sec) * 1000 //get number of ms since last call
     + (current_time.tv_usec - global_millisecs_tv.tv_usec) / 1000;
  global_millisecs += ms; //update global ms
  global_millisecs_tv = current_time; //remember time of last call
}
