/* BLINKENLIGHTS PROXY
 * version 0.94 date 2004-06-07
 * Copyright (C) 2003-2004 1stein <1stein@schuermans.info>
 * Copyleft: GNU public license - http://www.gnu.org/copyleft/gpl.html
 */

#ifndef INC_proto
#define INC_proto

//type for protocol
typedef enum e_proto et_proto;

//type for format
typedef struct s_format st_format;

//type for a frame
typedef struct s_frame st_frame;

#include "addr.h"
#include "output.h"



//type for protocol (see above)
enum e_proto { proto_none, proto_blp, proto_eblp, proto_mcuf, proto_any };

//read protocol from string
//<proto_any_ok> != 0 allows return value <proto_any>
//returns protocol on success, proto_none on error
et_proto proto_str2proto( char * p_str, int proto_any_ok, st_out_info * p_out_info );

//get string from protocol
//returns 0 on success, a negative value on error
int proto_proto2str( et_proto proto, char * p_str, unsigned int str_buf_size, st_out_info * p_out_info );

//output protocol
void proto_proto_out( et_proto proto, st_out_info * p_out_info );



//type for format (see above)
#define format_height_max 1000
#define format_width_max 1000
#define format_channels_max 3
#define format_colors_max 256
struct s_format
{
  unsigned short height, width; //dimensions of the picture, 0 if not specified
  unsigned short channels; //number of channels of the picture, 0 if not specified
  unsigned short colors; //number of colors of the picture (per channel), 0 if not specified, 1 is invalid
};

//constant for no format
#define format_none ((st_format){ .height = 0, .width = 0, .channels = 0, .colors = 0 })

//read format from string
//format of <format> ist [<width>x<height>][-<channels>][/<colors>]
//returns 0 on success, a negative value on error
int format_str2format( char * p_str, st_format * p_format, st_out_info * p_out_info );

//get string from format
//format of <format> ist [<width>x<height>][-<channels>][/<colors>]
//returns 0 on success, a negative value on error
int format_format2str( st_format * p_format, char * p_str, unsigned int str_buf_size, st_out_info * p_out_info );

//output format
//format of <format> ist [<width>x<height>][-<channels>][/<colors>]
void format_format_out( st_format * p_format, st_out_info * p_out_info );

//check if a certain format matches a general format
//retuns 1 on match, 0 on mismatch
int format_match( st_format * p_certain_format, st_format * p_general_format );



//parse message and generate a frame from it
//p_msg must point to a malloc-ed memory block with a message
//p_msg belongs to the frame after successful execution of this procedure
//returns a pointer to frame with initial use count of 1
//returns NULL in case of error
st_frame * frame_parse( st_addr * p_src_addr, st_addr * p_dest_addr, char * p_msg, unsigned int msg_len );

//get pointers to the addresses of the frame
void frame_get_addrs( st_frame * p_frame, st_addr ** pp_src_addr, st_addr ** pp_dest_addr );

//increment use count for a frame
void frame_inc_use( st_frame * p_frame );

//decrement use count for a frame
void frame_dec_use( st_frame * p_frame );

//check if a frame matches an address range, a protocol and a format
//retuns 1 on match, 0 on mismatch
int frame_match( st_frame * p_frame, st_addr_range * p_range, et_proto proto, st_format * p_format );



//send dynamic stream refresh
void proto_send_refresh( int sock, et_proto proto, st_addr * p_addr );

//send dynamic stream close
void proto_send_close( int sock, et_proto proto, st_addr * p_addr );

//send a frame
void proto_send_frame( int sock, et_proto proto, st_addr * p_addr, st_format format, st_frame * p_frame );

//parse a request
//returns protocol or proto_none on error
//*p_enable is set to 1 if sending frames should be enabled
et_proto proto_parse_request( char * p_msg, int len, int * p_enable );

//check if request matches an address range and a protocol
//retuns 1 on match, 0 on mismatch
int proto_request_match( st_addr * p_addr, et_proto proto, st_addr_range * p_range, et_proto proto_range );

#endif //#ifndef INC_proto
