/* BLINKENLIGHTS PROXY
 * version 0.93 date 2004-04-26
 * Copyright (C) 2003-2004 1stein <1stein@schuermans.info>
 * Copyleft: GNU public license - http://www.gnu.org/copyleft/gpl.html
 */

#ifndef INC_outport
#define INC_outport

//type for data of output port list items
typedef struct s_outport_data st_outport_data;

//type for an output port list
typedef struct s_outport_list st_outport_list;

#include "addr.h"
#include "dyndest.h"
#include "list.h"
#include "outfilter.h"
#include "output.h"
#include "statdest.h"
#include "stream.h"
#include "tools.h"

//create a new output port list
//returns the pointer to the list or NULL in case of error
st_outport_list * outport_new( st_out_info * p_out_info );

//free an output port list
void outport_free( st_outport_list * p_outport_list );

//add an output port to an output port list
//returns 0 on success, a negative value in case of error
int outport_add( st_outport_list * p_outport_list, char * p_name, char * p_addr, st_out_info * p_out_info );

//delete an output port from an output port list
//returns 0 on success, a negative value in case of error
int outport_del( st_outport_list * p_outport_list, char * p_name, st_out_info * p_out_info );

//list output ports in an output port list
void outport_list( st_outport_list * p_outport_list, st_out_info * p_out_info );

//get output port from list
//returns a pointer to data item or NULL in case of error
st_outport_data * outport_get( st_outport_list * p_outport_list, char * p_name, st_out_info * p_out_info );

//get stream list of output port
//returns a pointer to the stream list
st_stream_list * outport_stream_list( st_outport_data * p_outport_data );

//get static destination list of output port
//returns a pointer to the static destination list
st_statdest_list * outport_statdest_list( st_outport_data * p_outport_data );

//get filter list of output port
//returns a pointer to the ouput filter list
st_outfilter_list * outport_outfilter_list( st_outport_data * p_outport_data );

//get dynamic destination list of output port
//returns a pointer to the dynamic destination list
st_dyndest_list * outport_dyndest_list( st_outport_data * p_outport_data );

//get address of output port
//returns a pointer to the address
st_addr * outport_addr( st_outport_data * p_outport_data );

//get socket of output port
//returns the socket fd
int outport_sock( st_outport_data * p_outport_data );

//do periodic tasks for output ports
void outport_tick( st_outport_list * p_inport_list );

//put sockets in output port list info fd sets
void outport_fd_sets( st_outport_list * p_outport_list, st_select_fd_sets * p_fd_sets );

//process sockets in output port list that are in fd sets
void outport_process( st_outport_list * p_outport_list, st_select_fd_sets * p_fd_sets );

//send a frame to all destinations of output port
void outport_send_frame( st_outport_data * p_outport_data, st_frame * p_frame );

#endif //#ifndef INC_outport
