/* BLINKENLIGHTS PROXY
 * version 0.93 date 2004-04-26
 * Copyright (C) 2003-2004 1stein <1stein@schuermans.info>
 * Copyleft: GNU public license - http://www.gnu.org/copyleft/gpl.html
 */

#include <stdio.h>
#include <errno.h>
#include <sys/time.h>

#include "inport.h"
#include "outport.h"
#include "output.h"
#include "global.h"

//input port list
st_inport_list * p_global_inport_list; //(extern)

//output port list
st_outport_list * p_global_outport_list; //(extern)

//number of milliseconds since start of the program (wraps around!)
unsigned long global_millisecs; //(extern)

//initialize global stuff
//returns 0 on success, a negative value on error
int global_init( st_out_info * p_out_info )
{
  struct timeval current_time;

  //create input port list
  p_global_inport_list = inport_new( p_out_info );
  if( p_global_inport_list == NULL )
  {
    out_str( p_out_info, "  error: could not create input port list (out of memory)\n" );
    return -ENOMEM;
  }

  //create output port list
  p_global_outport_list = outport_new( p_out_info );
  if( p_global_outport_list == NULL )
  {
    inport_free( p_global_inport_list );
    out_str( p_out_info, "  error: could not create output port list (out of memory)\n" );
    return -ENOMEM;
  }

  //initialize milliseconds since start of the program
  gettimeofday( &current_time, NULL );
  global_millisecs = (unsigned long)current_time.tv_sec * 1000
                   + (unsigned long)current_time.tv_usec % 1000;

  return 0;
}

//cleanup global stuff
void global_exit( )
{
  //free input port list
  inport_free( p_global_inport_list );

  //free output port list
  outport_free( p_global_outport_list );
}

//do periodic global tasks
void global_tick( )
{
  struct timeval current_time;

  //update number of milliseconds since start of the program
  gettimeofday( &current_time, NULL );
  global_millisecs = (unsigned long)current_time.tv_sec * 1000
                   + (unsigned long)current_time.tv_usec / 1000;
}
