/* BLINKENLIGHTS PROXY
 * version 0.92 date 2004-04-07
 * Copyright (C) 2003 1stein <1stein@schuermans.info>
 * Copyleft: GNU public license - http://www.gnu.org/copyleft/gpl.html
 */

#ifndef INC_inport
#define INC_inport

//type for data of input port list items
typedef struct s_inport_data st_inport_data;

//type for an input port list
typedef struct s_inport_list st_inport_list;

#include "dynsrc.h"
#include "infilter.h"
#include "output.h"
#include "tools.h"

//create a new input port list
//returns the pointer to the list or NULL in case of error
st_inport_list * inport_new( st_out_info * p_out_info );

//free an input port list
void inport_free( st_inport_list * p_inport_list );

//add an input port to an input port list
//returns 0 on success, a negative value in case of error
int inport_add( st_inport_list * p_inport_list, char * p_name, char * p_addr, st_out_info * p_out_info );

//delete an input port from an input port list
//returns 0 on success, a negative value in case of error
int inport_del( st_inport_list * p_inport_list, char * p_name, st_out_info * p_out_info );

//list input ports in an input port list
void inport_list( st_inport_list * p_inport_list, st_out_info * p_out_info );

//get input port from list
//returns a pointer to data item or NULL in case of error
st_inport_data * inport_get( st_inport_list * p_inport_list, char * p_name, st_out_info * p_out_info );

//get dynamic source list of input port
//returns a pointer to the dynamic source list
st_dynsrc_list * inport_dynsrc_list( st_inport_data * p_inport_data );

//get filter list of input port
//returns a pointer to the input filter list
st_infilter_list * inport_infilter_list( st_inport_data * p_inport_data );

//get socket of input port
//returns the socket fd
int inport_sock( st_inport_data * p_inport_data );

//do periodic tasks for input ports
void inport_tick( st_inport_list * p_inport_list );

//put sockets in input port list info fd sets
void inport_fd_sets( st_inport_list * p_inport_list, st_select_fd_sets * p_fd_sets );

//process sockets in input port list that are in fd sets
void inport_process( st_inport_list * p_inport_list, st_select_fd_sets * p_fd_sets );

#endif //#ifndef INC_inport
