/* BLINKENLIGHTS PROXY
 * version 0.91 date 2003-12-29
 * Copyright (C) 2003 1stein <1stein@schuermans.info>
 * Copyleft: GNU public license - http://www.gnu.org/copyleft/gpl.html
 */

#ifndef INC_statdest
#define INC_statdest

//type for data of static destination list items
typedef struct s_statdest_data st_statdest_data;

//type for a static destination list
typedef struct s_statdest_list st_statdest_list;

#include "outport.h"
#include "output.h"
#include "proto.h"

//create a new static destination list
//<af> specifies the address family of this static destination list (obtained from owning port)
//returns the pointer to the list or NULL in case of error
st_statdest_list * statdest_new( int af, st_outport_data * p_outport_data, st_out_info * p_out_info );

//free a static destination list
void statdest_free( st_statdest_list * p_statdest_list );

//add a static destination to a static destination list
//returns 0 on success, a negative value in case of error
int statdest_add( st_statdest_list * p_statdest_list, char * p_name, char * p_addr, char * p_proto, char * p_format, st_out_info * p_out_info );

//delete a static destination from a static destination list
//returns 0 on success, a negative value in case of error
int statdest_del( st_statdest_list * p_statdest_list, char * p_name, st_out_info * p_out_info );

//list static destinations in a static destination list
void statdest_list( st_statdest_list * p_statdest_list, st_out_info * p_out_info );

//set format of a static destination in a static destination list
//returns 0 on success, a negative value in case of error
int statdest_set_format( st_statdest_list * p_statdest_list, char * p_name, char * p_format, st_out_info * p_out_info );

//send a frame to static destinations
void statdest_send_frame( st_statdest_list * p_statdest_list, st_frame * p_frame, int sock );

#endif //#ifndef INC_statdest
