/* BLINKENLIGHTS PROXY
 * version 0.91 date 2003-12-29
 * Copyright (C) 2003 1stein <1stein@schuermans.info>
 * Copyleft: GNU public license - http://www.gnu.org/copyleft/gpl.html
 */

#ifndef INC_olist
#define INC_olist

//type for a list
typedef struct s_olist st_olist;

//create a new ordered list
//returns NULL in case of error
st_olist * olist_new( );

//delete an ordered list (including all entries)
//data_free_func is called for the data of every list item (if not NULL)
void olist_free( st_olist * p_olist, void (*data_free_func)( void * ) );

//add an item to an ordered list
//returns 0 on success, a negative value on error
int olist_add( st_olist * p_olist, unsigned int index, void * p_data );

//delete an item from an ordered list
//data_free_func is called for the data of deleted list item (if not NULL)
//returns 0 on success, a negative value on error
int olist_del( st_olist * p_olist, unsigned int index, void (*data_free_func)( void * ) );

//get the data of an item in an ordered list
//returns the data pointer of NULL on error
void * olist_get( st_olist * p_olist, unsigned int index );

//enumerate all items in an ordered list
//the enumerations stops when enum_func retuns a value != 0
void olist_enum( st_olist * p_olist, int (*enum_func)( unsigned int, void *, void * ), void * p_enum_context );

#endif //#ifndef INC_olist
