/* BLINKENLIGHTS PROXY
 * version 0.100 date 2008-03-21
 * Copyright (C) 2003-2006 Stefan Schuermans <1stein@schuermans.info>
 * Copyleft: GNU public license - http://www.gnu.org/copyleft/gpl.html
 */

#ifndef INC_stream
#define INC_stream

//type for data of stream list items
typedef struct s_stream_data st_stream_data;

//type for a stream list
typedef struct s_stream_list st_stream_list;

#include "addr.h"
#include "outport.h"
#include "output.h"
#include "proto.h"

//create a new stream list
//returns the pointer to the list or NULL in case of error
st_stream_list * stream_new( st_outport_data * p_outport_data, st_out_info * p_out_info );

//free a stream list
void stream_free( st_stream_list * p_stream_list );

//list streams in a stream list
void stream_list( st_stream_list * p_stream_list, st_out_info * p_out_info );

//pass a frame to a stream list
//returns 0 on success, a negative value in case of error
int stream_frame( st_stream_list * p_stream_list, char * p_name, st_frame * p_frame, unsigned short priority, unsigned short timeout );

//do periodic work for a stream list
void stream_tick( st_stream_list * p_stream_list );

//send current frame to a destination
void stream_send_current_frame( st_stream_list * p_stream_list, et_proto proto, st_addr * p_addr, st_format * p_format );

//get current frame of a stream list
st_frame * stream_get_cur_frame( st_stream_list * p_stream_list );

#endif //#ifndef INC_stream
