/* BLINKENLIGHTS PROXY
 * version 0.100 date 2008-03-21
 * Copyright (C) 2003-2006 Stefan Schuermans <1stein@schuermans.info>
 * Copyleft: GNU public license - http://www.gnu.org/copyleft/gpl.html
 */

#ifndef INC_output
#define INC_output

//type for information about the output method
typedef enum e_out_method { e_out_none, e_out_fd } et_out_method;
typedef struct s_out_info
{
  et_out_method method;
  union
  {
    char none; //for e_out_none
    struct //for e_out_fd
    {
      int fd; //the file descriptor to output to
    } fd;
  } info;
} st_out_info;

//output informations
extern st_out_info * p_out_none;
extern st_out_info * p_out_stdout;

//generate an output information for output to an fd
st_out_info out_info_fd( int fd );

//output a string using the output method specified in <*p_out_info>
void out_str( st_out_info * p_out_info, char * p_str );

//flush output specified in <*p_out_info>
void out_flush( st_out_info * p_out_info );

#endif //#ifndef INC_output
