/* BLINKENLIGHTS PROXY
 * version 0.100 date 2008-03-21
 * Copyright (C) 2003-2006 Stefan Schuermans <1stein@schuermans.info>
 * Copyleft: GNU public license - http://www.gnu.org/copyleft/gpl.html
 */

#include <string.h>
#include <unistd.h>

#include "output.h"

//output informations
st_out_info * p_out_none = &(st_out_info){ .method = e_out_none, .info = { .none = 0 } };
st_out_info * p_out_stdout = &(st_out_info){ .method = e_out_fd, .info = { .fd = { .fd = 1 } } };

//generate an output information for output to an fd
st_out_info out_info_fd( int fd )
{
  return (st_out_info){ .method = e_out_fd, .info = { .fd = { .fd = fd } } };
}

//output a string using the output method specified in <*p_out_info>
void out_str( st_out_info * p_out_info, char * p_str )
{
  //switch according to method
  switch( p_out_info->method )
  {
    case e_out_none:
      break;
    case e_out_fd:
      write( p_out_info->info.fd.fd, p_str, strlen( p_str ) );
      break;
  }
}

//flush output specified in <*p_out_info>
void out_flush( st_out_info * p_out_info )
{
  //switch according to method
  switch( p_out_info->method )
  {
    case e_out_none:
      break;
    case e_out_fd:
      fsync( p_out_info->info.fd.fd );
      break;
  }
}
