//BlinkenStreamView
//version 0.1 date 2005-01-27
//Copyright 2005 Stefan Schuermans <1stein@schuermans.info>
//Copyleft: GNU public license - http://www.gnu.org/copyleft/gpl.html
//a blinkenarea.org project
//powered by eventphone.de

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"

#include "net.h"


//timer for sending requests
gboolean Interval_timer_active = FALSE;
guint Interval_timer;
unsigned int Interval_timer_interval = 0;


//request timer interval elapsed
gboolean Interval_interval( gpointer data )
{
  //send a request
  net_send_request( );

  //call this function again after the interval
  return TRUE;
}


//set new interval for request timer
static void Interval_timer_set_interval( char * pInterval )
{
  //abort old timer
  if( Interval_timer_active )
  {
    g_source_remove( Interval_timer );
    Interval_timer_active = FALSE;
  }

  //get new interval from string
  if( pInterval != NULL )
  {
    if( sscanf( pInterval, "%u", &Interval_timer_interval ) != 1 )
      Interval_timer_interval = 0;
  }

  //start new timer
  if( Interval_timer_interval > 0 )
  {
    Interval_timer_active = TRUE;
    Interval_timer = g_timeout_add( Interval_timer_interval * 1000,
                                    Interval_interval,
                                    NULL );
  }
}


void
on_Config_destroy                      (GtkObject       *object,
                                        gpointer         user_data)
{
  //stop request timer
  Interval_timer_set_interval( "" );
  //exit program
  gtk_main_quit( );
}


void
on_Display_destroy                     (GtkObject       *object,
                                        gpointer         user_data)
{
  on_Config_destroy( object, user_data );
}


void
on_Listen_activate                     (GtkEntry        *entry,
                                        gpointer         user_data)
{
  gchar * text;
  char buffer[64];
  gint pos;

  //set new listen address
  text = gtk_editable_get_chars( (GtkEditable *)entry, 0, -1 );
  if( text != NULL )
  {
    net_set_listen( text );
    net_get_listen( buffer, sizeof( buffer ) );
    gtk_editable_delete_text( (GtkEditable *)entry, 0, -1 );
    pos = 0;
    gtk_editable_insert_text( (GtkEditable *)entry, buffer, strlen( buffer ), &pos );  
    Interval_timer_set_interval( NULL ); //restart request timer
    g_free( text );
  }
}


gboolean
on_Listen_focus_out_event              (GtkWidget       *widget,
                                        GdkEventFocus   *event,
                                        gpointer         user_data)
{
  //editing ended, act as if enter had been pressed
  on_Listen_activate( (GtkEntry *)widget, NULL );
  return FALSE;
}


void
on_Interval_activate                   (GtkEntry        *entry,
                                        gpointer         user_data)
{
  gchar * text;

  //set new interval
  text = gtk_editable_get_chars( (GtkEditable *)entry, 0, -1 );
  if( text != NULL )
  {
    Interval_timer_set_interval( text );
    net_send_request( ); //send a request
    Interval_timer_set_interval( NULL ); //restart request timer
    g_free( text );
  }
}


gboolean
on_Interval_focus_out_event            (GtkWidget       *widget,
                                        GdkEventFocus   *event,
                                        gpointer         user_data)
{
  //editing ended, act as if enter had been pressed
  on_Interval_activate( (GtkEntry *)widget, NULL );
  return FALSE;
}


void
on_Send_activate                       (GtkEntry        *entry,
                                        gpointer         user_data)
{
  gchar * text;
  char buffer[64];
  gint pos;

  //set new send address
  text = gtk_editable_get_chars( (GtkEditable *)entry, 0, -1 );
  if( text != NULL )
  {
    net_set_send( text );
    net_get_send( buffer, sizeof( buffer ) );
    gtk_editable_delete_text( (GtkEditable *)entry, 0, -1 );
    pos = 0;
    gtk_editable_insert_text( (GtkEditable *)entry, buffer, strlen( buffer ), &pos );  
    Interval_timer_set_interval( NULL ); //restart request timer
    g_free( text );
  }
}


gboolean
on_Send_focus_out_event                (GtkWidget       *widget,
                                        GdkEventFocus   *event,
                                        gpointer         user_data)
{
  //editing ended, act as if enter had been pressed
  on_Send_activate( (GtkEntry *)widget, NULL );
  return FALSE;
}


void
on_Protocol_changed                    (GtkComboBox     *combobox,
                                        gpointer         user_data)
{
  //set new protocol
  net_set_protocol( gtk_combo_box_get_active( combobox ) );
  gtk_combo_box_set_active( combobox, net_get_protocol( ) );
  Interval_timer_set_interval( NULL ); //restart request timer
}


void
on_Zoom_activate                       (GtkEntry        *entry,
                                        gpointer         user_data)
{
  gchar * text;
  unsigned int zoom;
  char buffer[16];
  gint pos;

  //set new zoom factor
  text = gtk_editable_get_chars( (GtkEditable *)entry, 0, -1 );
  if( text != NULL )
  {
    if( sscanf( text, "%u", &zoom ) == 1 )
      net_set_zoom( zoom );
    g_free( text );
    snprintf( buffer, sizeof( buffer ), "%u", net_get_zoom( ) );
    gtk_editable_delete_text( (GtkEditable *)entry, 0, -1 );
    pos = 0;
    gtk_editable_insert_text( (GtkEditable *)entry, buffer, strlen( buffer ), &pos );  
  }
}


gboolean
on_Zoom_focus_out_event                (GtkWidget       *widget,
                                        GdkEventFocus   *event,
                                        gpointer         user_data)
{
  //editing ended, act as if enter had been pressed
  on_Zoom_activate( (GtkEntry *)widget, NULL );
  return FALSE;
}

