/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenarea.BlinkenLib;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.blinkenarea.BlinkenLib.BlinkenConstants;
import org.blinkenarea.BlinkenLib.BlinkenFrame;

public class BlinkenMovie {
    private int height;
    private int width;
    private int channels;
    private int maxval;
    private int infoCnt;
    private String[][] infos;
    private int frameCnt;
    private BlinkenFrame[] frames;

    public BlinkenMovie(int n, int n2, int n3, int n4) {
        if (n < BlinkenConstants.BlinkenHeightMin) {
            n = BlinkenConstants.BlinkenHeightMin;
        }
        if (n > BlinkenConstants.BlinkenHeightMax) {
            n = BlinkenConstants.BlinkenHeightMax;
        }
        if (n2 < BlinkenConstants.BlinkenWidthMin) {
            n2 = BlinkenConstants.BlinkenWidthMin;
        }
        if (n2 > BlinkenConstants.BlinkenWidthMax) {
            n2 = BlinkenConstants.BlinkenWidthMax;
        }
        if (n3 < BlinkenConstants.BlinkenChannelsMin) {
            n3 = BlinkenConstants.BlinkenChannelsMin;
        }
        if (n3 > BlinkenConstants.BlinkenChannelsMax) {
            n3 = BlinkenConstants.BlinkenChannelsMax;
        }
        if (n4 < BlinkenConstants.BlinkenMaxvalMin) {
            n4 = BlinkenConstants.BlinkenMaxvalMin;
        }
        if (n4 > BlinkenConstants.BlinkenMaxvalMax) {
            n4 = BlinkenConstants.BlinkenMaxvalMax;
        }
        this.height = n;
        this.width = n2;
        this.channels = n3;
        this.maxval = n4;
        this.infoCnt = 0;
        this.infos = new String[0][2];
        this.frameCnt = 0;
        this.frames = new BlinkenFrame[0];
    }

    public BlinkenMovie(BlinkenMovie blinkenMovie) {
        int n;
        this.height = blinkenMovie.height;
        this.width = blinkenMovie.width;
        this.channels = blinkenMovie.channels;
        this.maxval = blinkenMovie.maxval;
        this.infoCnt = 0;
        this.infos = new String[0][2];
        this.frameCnt = 0;
        this.frames = new BlinkenFrame[0];
        for (n = 0; n < blinkenMovie.infoCnt; ++n) {
            this.appendInfo(new String(blinkenMovie.infos[n][0]), new String(blinkenMovie.infos[n][1]));
        }
        for (n = 0; n < blinkenMovie.frameCnt; ++n) {
            this.appendFrame(new BlinkenFrame(blinkenMovie.frames[n]));
        }
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getChannels() {
        return this.channels;
    }

    public int getMaxval() {
        return this.maxval;
    }

    public int getDuration() {
        int n = 0;
        for (int i = 0; i < this.frameCnt; ++i) {
            n += this.frames[i].getDuration();
        }
        return n;
    }

    public int getInfoCnt() {
        return this.infoCnt;
    }

    public String getInfoType(int n) {
        if (this.infoCnt < 1) {
            return "";
        }
        if (n < 0) {
            n = 0;
        }
        if (n >= this.infoCnt) {
            n = this.infoCnt - 1;
        }
        return this.infos[n][0];
    }

    public String getInfoData(int n) {
        if (this.infoCnt < 1) {
            return "";
        }
        if (n < 0) {
            n = 0;
        }
        if (n >= this.infoCnt) {
            n = this.infoCnt - 1;
        }
        return this.infos[n][1];
    }

    public void setInfo(int n, String string, String string2) {
        if (n < 0 || n >= this.infoCnt) {
            return;
        }
        this.infos[n][0] = string;
        this.infos[n][1] = string2;
    }

    public void insertInfo(int n, String string, String string2) {
        int n2;
        if (n < 0 || n > this.infoCnt) {
            return;
        }
        String[][] stringArray = new String[this.infoCnt + 1][2];
        for (n2 = 0; n2 < n; ++n2) {
            stringArray[n2][0] = this.infos[n2][0];
            stringArray[n2][1] = this.infos[n2][1];
        }
        stringArray[n][0] = string;
        stringArray[n][1] = string2;
        for (n2 = n; n2 < this.infoCnt; ++n2) {
            stringArray[n2 + 1][0] = this.infos[n2][0];
            stringArray[n2 + 1][1] = this.infos[n2][1];
        }
        this.infos = stringArray;
        ++this.infoCnt;
    }

    public void appendInfo(String string, String string2) {
        this.insertInfo(this.infoCnt, string, string2);
    }

    public void deleteInfo(int n) {
        int n2;
        if (n < 0 || n >= this.infoCnt) {
            return;
        }
        String[][] stringArray = new String[this.infoCnt - 1][2];
        for (n2 = 0; n2 < n; ++n2) {
            stringArray[n2][0] = this.infos[n2][0];
            stringArray[n2][1] = this.infos[n2][1];
        }
        for (n2 = n; n2 < this.infoCnt - 1; ++n2) {
            stringArray[n2][0] = this.infos[n2 + 1][0];
            stringArray[n2][1] = this.infos[n2 + 1][1];
        }
        this.infos = stringArray;
        --this.infoCnt;
    }

    public void deleteInfos() {
        this.infos = new String[0][2];
        this.infoCnt = 0;
    }

    public int getFrameCnt() {
        return this.frameCnt;
    }

    public BlinkenFrame getFrame(int n) {
        if (this.frameCnt < 1) {
            BlinkenFrame blinkenFrame = new BlinkenFrame(this.height, this.width, this.channels, this.maxval, 0);
            blinkenFrame.clear();
            return blinkenFrame;
        }
        if (n < 0) {
            n = 0;
        }
        if (n >= this.frameCnt) {
            n = this.frameCnt - 1;
        }
        return this.frames[n];
    }

    public void setFrame(int n, BlinkenFrame blinkenFrame) {
        if (n < 0 || n >= this.frameCnt) {
            return;
        }
        blinkenFrame.resize(this.height, this.width, this.channels, this.maxval);
        this.frames[n] = blinkenFrame;
    }

    public void insertFrame(int n, BlinkenFrame blinkenFrame) {
        int n2;
        if (n < 0 || n > this.frameCnt) {
            return;
        }
        BlinkenFrame[] blinkenFrameArray = new BlinkenFrame[this.frameCnt + 1];
        for (n2 = 0; n2 < n; ++n2) {
            blinkenFrameArray[n2] = this.frames[n2];
        }
        blinkenFrame.resize(this.height, this.width, this.channels, this.maxval);
        blinkenFrameArray[n] = blinkenFrame;
        for (n2 = n; n2 < this.frameCnt; ++n2) {
            blinkenFrameArray[n2 + 1] = this.frames[n2];
        }
        this.frames = blinkenFrameArray;
        ++this.frameCnt;
    }

    public void appendFrame(BlinkenFrame blinkenFrame) {
        this.insertFrame(this.frameCnt, blinkenFrame);
    }

    public void deleteFrame(int n) {
        int n2;
        if (n < 0 || n >= this.frameCnt) {
            return;
        }
        BlinkenFrame[] blinkenFrameArray = new BlinkenFrame[this.frameCnt - 1];
        for (n2 = 0; n2 < n; ++n2) {
            blinkenFrameArray[n2] = this.frames[n2];
        }
        for (n2 = n; n2 < this.frameCnt - 1; ++n2) {
            blinkenFrameArray[n2] = this.frames[n2 + 1];
        }
        this.frames = blinkenFrameArray;
        --this.frameCnt;
    }

    public void deleteFrames() {
        this.frames = new BlinkenFrame[0];
        this.frameCnt = 0;
    }

    public void resize(int n, int n2, int n3, int n4) {
        if (n < BlinkenConstants.BlinkenHeightMin) {
            n = BlinkenConstants.BlinkenHeightMin;
        }
        if (n > BlinkenConstants.BlinkenHeightMax) {
            n = BlinkenConstants.BlinkenHeightMax;
        }
        if (n2 < BlinkenConstants.BlinkenWidthMin) {
            n2 = BlinkenConstants.BlinkenWidthMin;
        }
        if (n2 > BlinkenConstants.BlinkenWidthMax) {
            n2 = BlinkenConstants.BlinkenWidthMax;
        }
        if (n3 < BlinkenConstants.BlinkenChannelsMin) {
            n3 = BlinkenConstants.BlinkenChannelsMin;
        }
        if (n3 > BlinkenConstants.BlinkenChannelsMax) {
            n3 = BlinkenConstants.BlinkenChannelsMax;
        }
        if (n4 < BlinkenConstants.BlinkenMaxvalMin) {
            n4 = BlinkenConstants.BlinkenMaxvalMin;
        }
        if (n4 > BlinkenConstants.BlinkenMaxvalMax) {
            n4 = BlinkenConstants.BlinkenMaxvalMax;
        }
        this.height = n;
        this.width = n2;
        this.channels = n3;
        this.maxval = n4;
        for (int i = 0; i < this.frameCnt; ++i) {
            this.frames[i].resize(n, n2, n3, n4);
        }
    }

    public void scale(int n, int n2) {
        if (n < BlinkenConstants.BlinkenHeightMin) {
            n = BlinkenConstants.BlinkenHeightMin;
        }
        if (n > BlinkenConstants.BlinkenHeightMax) {
            n = BlinkenConstants.BlinkenHeightMax;
        }
        if (n2 < BlinkenConstants.BlinkenWidthMin) {
            n2 = BlinkenConstants.BlinkenWidthMin;
        }
        if (n2 > BlinkenConstants.BlinkenWidthMax) {
            n2 = BlinkenConstants.BlinkenWidthMax;
        }
        this.height = n;
        this.width = n2;
        for (int i = 0; i < this.frameCnt; ++i) {
            this.frames[i].scale(n, n2);
        }
    }

    public String toString() {
        int n;
        String string = "BlinkenMovie " + this.width + "x" + this.height + "-" + this.channels + "/" + (this.maxval + 1) + "\n";
        for (n = 0; n < this.infoCnt; ++n) {
            string = string + this.infos[n][0] + " = " + this.infos[n][1] + "\n";
        }
        for (n = 0; n < this.frameCnt; ++n) {
            string = string + "frame " + n + "\n" + this.frames[n].toString();
        }
        return string;
    }

    public boolean loadBlm(BufferedReader bufferedReader) {
        Pattern pattern = Pattern.compile("^ *# BlinkenLights Movie ([0-9]+)x([0-9]+)");
        Pattern pattern2 = Pattern.compile("^ *# ?([A-Za-z0-9]+)(?: *= *|: *)(.*)");
        Pattern pattern3 = Pattern.compile("^ *@([0-9]+)");
        Pattern pattern4 = Pattern.compile(" *([01])");
        this.deleteInfos();
        this.deleteFrames();
        this.resize(0, 0, 0, 0);
        try {
            Matcher matcher;
            String string = bufferedReader.readLine();
            if (string != null && (matcher = pattern.matcher(string)).find()) {
                int n = Integer.parseInt(matcher.group(1));
                int n2 = Integer.parseInt(matcher.group(2));
                this.resize(n2, n, 1, 1);
                BlinkenFrame blinkenFrame = new BlinkenFrame(this.height, this.width, 1, 1, 0);
                int n3 = 0;
                while ((string = bufferedReader.readLine()) != null) {
                    matcher = pattern2.matcher(string);
                    if (matcher.find()) {
                        this.appendInfo(matcher.group(1), matcher.group(2));
                        continue;
                    }
                    matcher = pattern3.matcher(string);
                    if (matcher.find()) {
                        int n4 = Integer.parseInt(matcher.group(1));
                        blinkenFrame = new BlinkenFrame(this.height, this.width, 1, 1, n4);
                        blinkenFrame.clear();
                        this.appendFrame(blinkenFrame);
                        n3 = 0;
                        continue;
                    }
                    matcher = pattern4.matcher(string);
                    if (!matcher.find()) continue;
                    int n5 = 0;
                    while (true) {
                        String string2 = matcher.group(1);
                        int n6 = Integer.parseInt(string2);
                        blinkenFrame.setPixel(n3, n5, 0, (byte)n6);
                        if (!matcher.find()) break;
                        ++n5;
                    }
                    ++n3;
                }
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean loadBlm(String string) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            boolean bl = this.loadBlm(bufferedReader);
            bufferedReader.close();
            return bl;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean loadBmm(BufferedReader bufferedReader) {
        Pattern pattern = Pattern.compile("^ *# BlinkenMini Movie ([0-9]+)x([0-9]+)");
        Pattern pattern2 = Pattern.compile("^ *# ?([A-Za-z0-9]+)(?: *= *|: *)(.*)");
        Pattern pattern3 = Pattern.compile("^ *@([0-9]+)");
        Pattern pattern4 = Pattern.compile(" *(0x[0-9A-Fa-f]+|[0-9]+)");
        this.deleteInfos();
        this.deleteFrames();
        this.resize(0, 0, 0, 0);
        try {
            Matcher matcher;
            String string = bufferedReader.readLine();
            if (string != null && (matcher = pattern.matcher(string)).find()) {
                int n = Integer.parseInt(matcher.group(1));
                int n2 = Integer.parseInt(matcher.group(2));
                this.resize(n2, n, 1, 255);
                BlinkenFrame blinkenFrame = new BlinkenFrame(this.height, this.width, 1, 255, 0);
                int n3 = 0;
                while ((string = bufferedReader.readLine()) != null) {
                    matcher = pattern2.matcher(string);
                    if (matcher.find()) {
                        this.appendInfo(matcher.group(1), matcher.group(2));
                        continue;
                    }
                    matcher = pattern3.matcher(string);
                    if (matcher.find()) {
                        int n4 = Integer.parseInt(matcher.group(1));
                        blinkenFrame = new BlinkenFrame(this.height, this.width, 1, 255, n4);
                        blinkenFrame.clear();
                        this.appendFrame(blinkenFrame);
                        n3 = 0;
                        continue;
                    }
                    matcher = pattern4.matcher(string);
                    if (!matcher.find()) continue;
                    int n5 = 0;
                    while (true) {
                        String string2;
                        int n6 = (string2 = matcher.group(1)).length() >= 2 && string2.substring(0, 2).equals("0x") ? Integer.parseInt(string2.substring(2), 16) : Integer.parseInt(string2);
                        blinkenFrame.setPixel(n3, n5, 0, (byte)n6);
                        if (!matcher.find()) break;
                        ++n5;
                    }
                    ++n3;
                }
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean loadBmm(String string) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            boolean bl = this.loadBmm(bufferedReader);
            bufferedReader.close();
            return bl;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean loadBml(BufferedReader bufferedReader) {
        Pattern pattern = Pattern.compile("^[^<]*<blm([^>]*)>");
        Pattern pattern2 = Pattern.compile("height=\"?([0-9]*)\"?");
        Pattern pattern3 = Pattern.compile("width=\"?([0-9]*)\"?");
        Pattern pattern4 = Pattern.compile("channels=\"?([0-9]*)\"?");
        Pattern pattern5 = Pattern.compile("bits=\"?([0-9]*)\"?");
        Pattern pattern6 = Pattern.compile("^[^<]*<title>([^<]*)</title>");
        Pattern pattern7 = Pattern.compile("[^<]*<description>([^<]*)</description>");
        Pattern pattern8 = Pattern.compile("^([A-Za-z0-9]+)(?: *= *|: *)(.*)");
        Pattern pattern9 = Pattern.compile("^[^<]*<creator>([^<]*)</creator>");
        Pattern pattern10 = Pattern.compile("^[^<]*<author>([^<]*)</author>");
        Pattern pattern11 = Pattern.compile("^[^<]*<email>([^<]*)</email>");
        Pattern pattern12 = Pattern.compile("^[^<]*<url>([^<]*)</url>");
        Pattern pattern13 = Pattern.compile("^[^<]*<frame([^>]*)>");
        Pattern pattern14 = Pattern.compile("duration=\"?([0-9]*)\"?");
        Pattern pattern15 = Pattern.compile("^[^<]*<row>([0-9A-Fa-f]*)</row>");
        Pattern pattern16 = Pattern.compile("^[^<]*<[^>]*>");
        this.deleteInfos();
        this.deleteFrames();
        this.resize(0, 0, 0, 0);
        try {
            String string;
            BlinkenFrame blinkenFrame = new BlinkenFrame(0, 0, 0, 0, 0);
            int n = 0;
            int n2 = 1;
            String string2 = "";
            boolean bl = false;
            block2: while ((string = bufferedReader.readLine()) != null) {
                string2 = string2 + " " + string;
                while (true) {
                    Matcher matcher;
                    Matcher matcher2;
                    if (!bl) {
                        matcher2 = pattern.matcher(string2);
                        if (matcher2.find()) {
                            string2 = string2.substring(matcher2.end());
                            int n3 = 0;
                            int n4 = 0;
                            int n5 = 1;
                            int n6 = 4;
                            int n7 = 15;
                            matcher = pattern2.matcher(matcher2.group(1));
                            if (matcher.find()) {
                                n4 = Integer.parseInt(matcher.group(1));
                            }
                            if ((matcher = pattern3.matcher(matcher2.group(1))).find()) {
                                n3 = Integer.parseInt(matcher.group(1));
                            }
                            if ((matcher = pattern4.matcher(matcher2.group(1))).find()) {
                                n5 = Integer.parseInt(matcher.group(1));
                            }
                            if ((matcher = pattern5.matcher(matcher2.group(1))).find()) {
                                n6 = Integer.parseInt(matcher.group(1));
                                n7 = (1 << n6) - 1;
                            }
                            bl = true;
                            this.resize(n4, n3, n5, n7);
                            n2 = n6 + 3 >> 2;
                            continue;
                        }
                        matcher2 = pattern16.matcher(string2);
                        if (!matcher2.find()) continue block2;
                        string2 = string2.substring(matcher2.end());
                        continue;
                    }
                    matcher2 = pattern6.matcher(string2);
                    if (matcher2.find()) {
                        string2 = string2.substring(matcher2.end());
                        this.appendInfo("title", matcher2.group(1));
                        continue;
                    }
                    matcher2 = pattern7.matcher(string2);
                    if (matcher2.find()) {
                        string2 = string2.substring(matcher2.end());
                        matcher = pattern8.matcher(matcher2.group(1));
                        if (matcher.find()) {
                            this.appendInfo(matcher.group(1), matcher.group(2));
                            continue;
                        }
                        this.appendInfo("description", matcher2.group(1));
                        continue;
                    }
                    matcher2 = pattern9.matcher(string2);
                    if (matcher2.find()) {
                        string2 = string2.substring(matcher2.end());
                        this.appendInfo("creator", matcher2.group(1));
                        continue;
                    }
                    matcher2 = pattern10.matcher(string2);
                    if (matcher2.find()) {
                        string2 = string2.substring(matcher2.end());
                        this.appendInfo("author", matcher2.group(1));
                        continue;
                    }
                    matcher2 = pattern11.matcher(string2);
                    if (matcher2.find()) {
                        string2 = string2.substring(matcher2.end());
                        this.appendInfo("email", matcher2.group(1));
                        continue;
                    }
                    matcher2 = pattern12.matcher(string2);
                    if (matcher2.find()) {
                        string2 = string2.substring(matcher2.end());
                        this.appendInfo("url", matcher2.group(1));
                        continue;
                    }
                    matcher2 = pattern13.matcher(string2);
                    if (matcher2.find()) {
                        string2 = string2.substring(matcher2.end());
                        int n8 = 0;
                        matcher = pattern14.matcher(matcher2.group(1));
                        if (matcher.find()) {
                            n8 = Integer.parseInt(matcher.group(1));
                        }
                        blinkenFrame = new BlinkenFrame(this.height, this.width, this.channels, this.maxval, n8);
                        blinkenFrame.clear();
                        this.appendFrame(blinkenFrame);
                        n = 0;
                        continue;
                    }
                    matcher2 = pattern15.matcher(string2);
                    if (matcher2.find()) {
                        string2 = string2.substring(matcher2.end());
                        String string3 = matcher2.group(1);
                        int n9 = string3.length();
                        int n10 = 0;
                        for (int i = 0; i < this.width && n10 + n2 <= n9; ++i) {
                            int n11 = 0;
                            while (n11 < this.channels && n10 + n2 <= n9) {
                                int n12 = Integer.parseInt(string3.substring(n10, n10 + n2), 16);
                                blinkenFrame.setPixel(n, i, n11, (byte)n12);
                                ++n11;
                                n10 += n2;
                            }
                        }
                        ++n;
                        continue;
                    }
                    matcher2 = pattern16.matcher(string2);
                    if (!matcher2.find()) continue block2;
                    string2 = string2.substring(matcher2.end());
                }
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean loadBml(String string) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            boolean bl = this.loadBml(bufferedReader);
            bufferedReader.close();
            return bl;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean loadBbm(String string) {
        this.deleteInfos();
        this.deleteFrames();
        this.resize(0, 0, 0, 0);
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(string, "r");
            byte[] byArray = new byte[24];
            randomAccessFile.readFully(byArray);
            int n = (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
            int n2 = (byArray[4] & 0xFF) << 8 | byArray[5] & 0xFF;
            int n3 = (byArray[6] & 0xFF) << 8 | byArray[7] & 0xFF;
            int n4 = (byArray[8] & 0xFF) << 8 | byArray[9] & 0xFF;
            int n5 = (byArray[10] & 0xFF) << 8 | byArray[11] & 0xFF;
            int n6 = (byArray[12] & 0xFF) << 24 | (byArray[13] & 0xFF) << 16 | (byArray[14] & 0xFF) << 8 | byArray[15] & 0xFF;
            int n7 = (byArray[16] & 0xFF) << 24 | (byArray[17] & 0xFF) << 16 | (byArray[18] & 0xFF) << 8 | byArray[19] & 0xFF;
            int n8 = (byArray[20] & 0xFF) << 24 | (byArray[21] & 0xFF) << 16 | (byArray[22] & 0xFF) << 8 | byArray[23] & 0xFF;
            if (n == 592717414) {
                this.resize(n2, n3, n4, n5);
                byte[] byArray2 = new byte[6];
                while (randomAccessFile.getFilePointer() + 6L <= (long)n8) {
                    randomAccessFile.readFully(byArray2);
                    int n9 = (byArray2[0] & 0xFF) << 24 | (byArray2[1] & 0xFF) << 16 | (byArray2[2] & 0xFF) << 8 | byArray2[3] & 0xFF;
                    int n10 = (byArray2[4] & 0xFF) << 8 | byArray2[5] & 0xFF;
                    if (n10 < 6 || randomAccessFile.getFilePointer() + (long)n10 - 6L > (long)n8) continue;
                    if (n9 == 1768842863) {
                        byte[] byArray3 = new byte[n10 - 6];
                        randomAccessFile.readFully(byArray3);
                        StringTokenizer stringTokenizer = new StringTokenizer(new String(byArray3), "\u0000");
                        if (stringTokenizer.countTokens() < 2) continue;
                        String string2 = stringTokenizer.nextToken();
                        String string3 = stringTokenizer.nextToken();
                        this.appendInfo(string2, string3);
                        continue;
                    }
                    randomAccessFile.skipBytes(n10 - 6);
                }
                randomAccessFile.seek(n8);
                byte[] byArray4 = new byte[4];
                randomAccessFile.readFully(byArray4);
                int n11 = (byArray4[0] & 0xFF) << 24 | (byArray4[1] & 0xFF) << 16 | (byArray4[2] & 0xFF) << 8 | byArray4[3] & 0xFF;
                if (n11 == 1718775155) {
                    int n12 = (int)randomAccessFile.length();
                    int n13 = 2 + n2 * n3 * n4;
                    byte[] byArray5 = new byte[n13];
                    while (randomAccessFile.getFilePointer() + (long)n13 <= (long)n12) {
                        randomAccessFile.readFully(byArray5);
                        int n14 = (byArray5[0] & 0xFF) << 8 | byArray5[1] & 0xFF;
                        BlinkenFrame blinkenFrame = new BlinkenFrame(this.height, this.width, this.channels, this.maxval, n14);
                        int n15 = 2;
                        for (int i = 0; i < n2; ++i) {
                            for (int j = 0; j < n3; ++j) {
                                int n16 = 0;
                                while (n16 < n4) {
                                    blinkenFrame.setPixel(i, j, n16, byArray5[n15]);
                                    ++n16;
                                    ++n15;
                                }
                            }
                        }
                        this.appendFrame(blinkenFrame);
                    }
                }
            }
            randomAccessFile.close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean load(String string) {
        if (string.endsWith(".blm")) {
            return this.loadBlm(string);
        }
        if (string.endsWith(".bmm")) {
            return this.loadBmm(string);
        }
        if (string.endsWith(".bml")) {
            return this.loadBml(string);
        }
        if (string.endsWith(".bbm")) {
            return this.loadBbm(string);
        }
        this.deleteFrames();
        return false;
    }

    public boolean saveBlm(BufferedWriter bufferedWriter) {
        BlinkenMovie blinkenMovie = new BlinkenMovie(this);
        blinkenMovie.resize(blinkenMovie.height, blinkenMovie.width, 1, 1);
        try {
            int n;
            bufferedWriter.write("# BlinkenLights Movie " + blinkenMovie.width + "x" + blinkenMovie.height + "\n");
            int n2 = blinkenMovie.getInfoCnt();
            for (n = 0; n < n2; ++n) {
                bufferedWriter.write("# " + blinkenMovie.getInfoType(n) + " = " + blinkenMovie.getInfoData(n) + "\n");
            }
            n2 = blinkenMovie.getFrameCnt();
            for (n = 0; n < n2; ++n) {
                bufferedWriter.write("\n@" + blinkenMovie.frames[n].getDuration() + "\n");
                for (int i = 0; i < blinkenMovie.height; ++i) {
                    String string = "";
                    for (int j = 0; j < blinkenMovie.width; ++j) {
                        string = blinkenMovie.frames[n].getPixel(i, j, 0) != 0 ? string + "1" : string + "0";
                    }
                    bufferedWriter.write(string + "\n");
                }
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean saveBlm(String string) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            boolean bl = this.saveBlm(bufferedWriter);
            bufferedWriter.close();
            return bl;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean saveBmm(BufferedWriter bufferedWriter) {
        BlinkenMovie blinkenMovie = new BlinkenMovie(this);
        blinkenMovie.resize(blinkenMovie.height, blinkenMovie.width, 1, 255);
        try {
            int n;
            bufferedWriter.write("# BlinkenMini Movie " + blinkenMovie.width + "x" + blinkenMovie.height + "\n");
            int n2 = blinkenMovie.getInfoCnt();
            for (n = 0; n < n2; ++n) {
                bufferedWriter.write("# " + blinkenMovie.getInfoType(n) + " = " + blinkenMovie.getInfoData(n) + "\n");
            }
            n2 = blinkenMovie.getFrameCnt();
            for (n = 0; n < n2; ++n) {
                bufferedWriter.write("\n@" + blinkenMovie.frames[n].getDuration() + "\n");
                for (int i = 0; i < blinkenMovie.height; ++i) {
                    String string = "";
                    for (int j = 0; j < blinkenMovie.width; ++j) {
                        int n3 = blinkenMovie.frames[n].getPixel(i, j, 0) & 0xFF;
                        string = n3 < 16 ? string + " 0x0" + Integer.toHexString(n3).toUpperCase() : string + " 0x" + Integer.toHexString(n3).toUpperCase();
                    }
                    bufferedWriter.write(string.substring(1) + "\n");
                }
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean saveBmm(String string) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            boolean bl = this.saveBmm(bufferedWriter);
            bufferedWriter.close();
            return bl;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean saveBml(BufferedWriter bufferedWriter) {
        BlinkenMovie blinkenMovie = new BlinkenMovie(this);
        int n = blinkenMovie.maxval;
        int n2 = 0;
        while (n != 0) {
            n >>= 1;
            ++n2;
        }
        blinkenMovie.resize(blinkenMovie.height, blinkenMovie.width, blinkenMovie.channels, (1 << n2) - 1);
        try {
            int n3;
            bufferedWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            bufferedWriter.write("<blm width=\"" + blinkenMovie.width + "\" height=\"" + blinkenMovie.height + "\" bits=\"" + n2 + "\" channels=\"" + blinkenMovie.channels + "\">\n");
            bufferedWriter.write("\t<header>\n");
            int n4 = blinkenMovie.getInfoCnt();
            for (n3 = 0; n3 < n4; ++n3) {
                String string = blinkenMovie.getInfoType(n3);
                String string2 = blinkenMovie.getInfoData(n3);
                if (string.equals("title")) {
                    bufferedWriter.write("\t\t<title>" + string2 + "</title>\n");
                    continue;
                }
                if (string.equals("description")) {
                    bufferedWriter.write("\t\t<description>" + string2 + "</description>\n");
                    continue;
                }
                if (string.equals("creator")) {
                    bufferedWriter.write("\t\t<creator>" + string2 + "</creator>\n");
                    continue;
                }
                if (string.equals("author")) {
                    bufferedWriter.write("\t\t<author>" + string2 + "</author>\n");
                    continue;
                }
                if (string.equals("email")) {
                    bufferedWriter.write("\t\t<email>" + string2 + "</email>\n");
                    continue;
                }
                if (string.equals("url")) {
                    bufferedWriter.write("\t\t<url>" + string2 + "</url>\n");
                    continue;
                }
                bufferedWriter.write("\t\t<description>" + string + ": " + string2 + "</description>\n");
            }
            bufferedWriter.write("\t</header>\n");
            n4 = blinkenMovie.getFrameCnt();
            for (n3 = 0; n3 < n4; ++n3) {
                bufferedWriter.write("\n\t<frame duration=\"" + blinkenMovie.frames[n3].getDuration() + "\">\n");
                for (int i = 0; i < blinkenMovie.height; ++i) {
                    String string = "";
                    for (int j = 0; j < blinkenMovie.width; ++j) {
                        for (int k = 0; k < blinkenMovie.channels; ++k) {
                            n = blinkenMovie.frames[n3].getPixel(i, j, k) & 0xFF;
                            string = n2 > 4 && n < 16 ? string + "0" + Integer.toHexString(n).toUpperCase() : string + Integer.toHexString(n).toUpperCase();
                        }
                    }
                    bufferedWriter.write("\t\t<row>" + string + "</row>\n");
                }
                bufferedWriter.write("\t</frame>\n");
            }
            bufferedWriter.write("</blm>\n");
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean saveBml(String string) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            boolean bl = this.saveBml(bufferedWriter);
            bufferedWriter.close();
            return bl;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean saveBbm(String string) {
        try {
            int n;
            int n2;
            RandomAccessFile randomAccessFile = new RandomAccessFile(string, "rw");
            randomAccessFile.setLength(0L);
            byte[] byArray = new byte[24];
            byArray[0] = 35;
            byArray[1] = 84;
            byArray[2] = 38;
            byArray[3] = 102;
            byArray[4] = (byte)(this.height >> 8);
            byArray[5] = (byte)this.height;
            byArray[6] = (byte)(this.width >> 8);
            byArray[7] = (byte)this.width;
            byArray[8] = (byte)(this.channels >> 8);
            byArray[9] = (byte)this.channels;
            byArray[10] = (byte)(this.maxval >> 8);
            byArray[11] = (byte)this.maxval;
            int n3 = this.getFrameCnt();
            byArray[12] = (byte)(n3 >> 24);
            byArray[13] = (byte)(n3 >> 16);
            byArray[14] = (byte)(n3 >> 8);
            byArray[15] = (byte)n3;
            int n4 = 0;
            for (n2 = 0; n2 < n3; ++n2) {
                n4 += this.frames[n2].getDuration();
            }
            byArray[16] = (byte)(n4 >> 24);
            byArray[17] = (byte)(n4 >> 16);
            byArray[18] = (byte)(n4 >> 8);
            byArray[19] = (byte)n4;
            byArray[20] = 0;
            byArray[21] = 0;
            byArray[22] = 0;
            byArray[23] = 0;
            randomAccessFile.write(byArray);
            n3 = this.getInfoCnt();
            for (n2 = 0; n2 < n3; ++n2) {
                String string2;
                String string3 = this.getInfoType(n2);
                if (string3.length() > 32760) {
                    string3 = string3.substring(0, 32760);
                }
                if ((string2 = this.getInfoData(n2)).length() > 32760) {
                    string2 = string2.substring(0, 32760);
                }
                n = 8 + string3.length() + string2.length();
                byte[] byArray2 = new byte[]{105, 110, 102, 111, (byte)(n >> 8), (byte)n};
                randomAccessFile.write(byArray2);
                randomAccessFile.write((string3 + "\u0000" + string2 + "\u0000").getBytes());
            }
            byte[] byArray3 = new byte[4];
            int n5 = (int)randomAccessFile.getFilePointer();
            byArray3[0] = (byte)(n5 >> 24);
            byArray3[1] = (byte)(n5 >> 16);
            byArray3[2] = (byte)(n5 >> 8);
            byArray3[3] = (byte)n5;
            randomAccessFile.seek(20L);
            randomAccessFile.write(byArray3);
            randomAccessFile.seek(n5);
            byte[] byArray4 = new byte[]{102, 114, 109, 115};
            randomAccessFile.write(byArray4);
            n = 2 + this.height * this.width * this.channels;
            byte[] byArray5 = new byte[n];
            n3 = this.getFrameCnt();
            for (n2 = 0; n2 < n3; ++n2) {
                n5 = this.frames[n2].getDuration();
                byArray5[0] = (byte)(n5 >> 8);
                byArray5[1] = (byte)n5;
                int n6 = 2;
                for (int i = 0; i < this.height; ++i) {
                    for (int j = 0; j < this.width; ++j) {
                        int n7 = 0;
                        while (n7 < this.channels) {
                            byArray5[n6] = this.frames[n2].getPixel(i, j, n7);
                            ++n7;
                            ++n6;
                        }
                    }
                }
                randomAccessFile.write(byArray5);
            }
            randomAccessFile.close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean save(String string) {
        if (string.endsWith(".blm")) {
            return this.saveBlm(string);
        }
        if (string.endsWith(".bmm")) {
            return this.saveBmm(string);
        }
        if (string.endsWith(".bml")) {
            return this.saveBml(string);
        }
        if (string.endsWith(".bbm")) {
            return this.saveBbm(string);
        }
        return false;
    }
}

