/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenarea.BlinkenLib;

import java.awt.Color;
import org.blinkenarea.BlinkenLib.BlinkenConstants;

public class BlinkenFrame {
    private static byte[] BlinkenProtoBlpMagic = new byte[]{-34, -83, -66, -17};
    private static byte[] BlinkenProtoEblpMagic = new byte[]{-2, -19, -66, -17};
    private static byte[] BlinkenProtoMcufMagic = new byte[]{35, 84, 38, 102};
    private int height;
    private int width;
    private int channels;
    private int maxval;
    private int duration;
    private byte[][] data;

    public BlinkenFrame(int n, int n2, int n3, int n4, int n5) {
        if (n < BlinkenConstants.BlinkenHeightMin) {
            n = BlinkenConstants.BlinkenHeightMin;
        }
        if (n > BlinkenConstants.BlinkenHeightMax) {
            n = BlinkenConstants.BlinkenHeightMax;
        }
        if (n2 < BlinkenConstants.BlinkenWidthMin) {
            n2 = BlinkenConstants.BlinkenWidthMin;
        }
        if (n2 > BlinkenConstants.BlinkenWidthMax) {
            n2 = BlinkenConstants.BlinkenWidthMax;
        }
        if (n3 < BlinkenConstants.BlinkenChannelsMin) {
            n3 = BlinkenConstants.BlinkenChannelsMin;
        }
        if (n3 > BlinkenConstants.BlinkenChannelsMax) {
            n3 = BlinkenConstants.BlinkenChannelsMax;
        }
        if (n4 < BlinkenConstants.BlinkenMaxvalMin) {
            n4 = BlinkenConstants.BlinkenMaxvalMin;
        }
        if (n4 > BlinkenConstants.BlinkenMaxvalMax) {
            n4 = BlinkenConstants.BlinkenMaxvalMax;
        }
        if (n5 < BlinkenConstants.BlinkenDurationMin) {
            n5 = BlinkenConstants.BlinkenDurationMin;
        }
        if (n5 > BlinkenConstants.BlinkenDurationMax) {
            n5 = BlinkenConstants.BlinkenDurationMax;
        }
        this.height = n;
        this.width = n2;
        this.channels = n3;
        this.maxval = n4;
        this.duration = n5;
        this.data = new byte[n][n2 * n3];
    }

    public BlinkenFrame(BlinkenFrame blinkenFrame) {
        this.height = blinkenFrame.height;
        this.width = blinkenFrame.width;
        this.channels = blinkenFrame.channels;
        this.maxval = blinkenFrame.maxval;
        this.duration = blinkenFrame.duration;
        this.data = new byte[this.height][this.width * this.channels];
        for (int i = 0; i < this.height; ++i) {
            int n = 0;
            for (int j = 0; j < this.width; ++j) {
                int n2 = 0;
                while (n2 < this.channels) {
                    this.data[i][n] = blinkenFrame.data[i][n];
                    ++n2;
                    ++n;
                }
            }
        }
    }

    public void clear() {
        for (int i = 0; i < this.height; ++i) {
            int n = 0;
            for (int j = 0; j < this.width; ++j) {
                int n2 = 0;
                while (n2 < this.channels) {
                    this.data[i][n] = 0;
                    ++n2;
                    ++n;
                }
            }
        }
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getChannels() {
        return this.channels;
    }

    public int getMaxval() {
        return this.maxval;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int n) {
        if (n < BlinkenConstants.BlinkenDurationMin) {
            n = BlinkenConstants.BlinkenDurationMin;
        }
        if (n > BlinkenConstants.BlinkenDurationMax) {
            n = BlinkenConstants.BlinkenDurationMax;
        }
        this.duration = n;
    }

    public byte getPixel(int n, int n2, int n3) {
        if (n < 0 || n >= this.height || n2 < 0 || n2 >= this.width || n3 < 0 || n3 >= this.channels) {
            return 0;
        }
        return this.data[n][n2 * this.channels + n3];
    }

    public void setPixel(int n, int n2, int n3, byte by) {
        if (n < 0 || n >= this.height || n2 < 0 || n2 >= this.width || n3 < 0 || n3 >= this.channels) {
            return;
        }
        if (by > this.maxval) {
            by = (byte)this.maxval;
        }
        this.data[n][n2 * this.channels + n3] = by;
    }

    public Color getColor(int n, int n2) {
        if (n < 0 || n >= this.height || n2 < 0 || n2 >= this.width || this.channels < 1) {
            return new Color(0, 0, 0);
        }
        if (this.channels == 1) {
            return new Color(((this.data[n][n2 * 1 + 0] & 0xFF) * 255 + this.maxval / 2) / this.maxval, ((this.data[n][n2 * 1 + 0] & 0xFF) * 255 + this.maxval / 2) / this.maxval, ((this.data[n][n2 * 1 + 0] & 0xFF) * 255 + this.maxval / 2) / this.maxval);
        }
        if (this.channels == 2) {
            return new Color(((this.data[n][n2 * 2 + 0] & 0xFF) * 255 + this.maxval / 2) / this.maxval, ((this.data[n][n2 * 2 + 1] & 0xFF) * 255 + this.maxval / 2) / this.maxval, 0);
        }
        int n3 = n2 * this.channels;
        return new Color(((this.data[n][n3 + 0] & 0xFF) * 255 + this.maxval / 2) / this.maxval, ((this.data[n][n3 + 1] & 0xFF) * 255 + this.maxval / 2) / this.maxval, ((this.data[n][n3 + 2] & 0xFF) * 255 + this.maxval / 2) / this.maxval);
    }

    public void setColor(int n, int n2, Color color) {
        if (n < 0 || n >= this.height || n2 < 0 || n2 >= this.width) {
            return;
        }
        int n3 = n2 * this.channels;
        int n4 = color.getAlpha();
        int n5 = 255 - n4;
        if (this.channels >= 1) {
            this.data[n][n3 + 0] = (byte)(((color.getRed() * this.maxval + 127) / 255 * n4 + (this.data[n][n3 + 0] & 0xFF) * n5) / 255);
        }
        if (this.channels >= 2) {
            this.data[n][n3 + 1] = (byte)(((color.getGreen() * this.maxval + 127) / 255 * n4 + (this.data[n][n3 + 1] & 0xFF) * n5) / 255);
        }
        if (this.channels >= 3) {
            this.data[n][n3 + 2] = (byte)(((color.getBlue() * this.maxval + 127) / 255 * n4 + (this.data[n][n3 + 2] & 0xFF) * n5) / 255);
        }
        for (int i = 3; i < this.channels; ++i) {
            this.data[n][n3 + i] = (byte)((0 + (this.data[n][n3 + i] & 0xFF) * n5) / 255);
        }
    }

    public void resize(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        if (n < BlinkenConstants.BlinkenHeightMin) {
            n = BlinkenConstants.BlinkenHeightMin;
        }
        if (n > BlinkenConstants.BlinkenHeightMax) {
            n = BlinkenConstants.BlinkenHeightMax;
        }
        if (n2 < BlinkenConstants.BlinkenWidthMin) {
            n2 = BlinkenConstants.BlinkenWidthMin;
        }
        if (n2 > BlinkenConstants.BlinkenWidthMax) {
            n2 = BlinkenConstants.BlinkenWidthMax;
        }
        if (n3 < BlinkenConstants.BlinkenChannelsMin) {
            n3 = BlinkenConstants.BlinkenChannelsMin;
        }
        if (n3 > BlinkenConstants.BlinkenChannelsMax) {
            n3 = BlinkenConstants.BlinkenChannelsMax;
        }
        if (n4 < BlinkenConstants.BlinkenMaxvalMin) {
            n4 = BlinkenConstants.BlinkenMaxvalMin;
        }
        if (n4 > BlinkenConstants.BlinkenMaxvalMax) {
            n4 = BlinkenConstants.BlinkenMaxvalMax;
        }
        if (n == this.height && n2 == this.width && n3 == this.channels && n4 == this.maxval) {
            return;
        }
        byte[][] byArray = new byte[n][n2 * n3];
        for (n13 = 0; n13 < n; ++n13) {
            int n14 = 0;
            for (n12 = 0; n12 < n2; ++n12) {
                n11 = 0;
                while (n11 < n3) {
                    byArray[n13][n14] = 0;
                    ++n11;
                    ++n14;
                }
            }
        }
        if (n > this.height) {
            n10 = (n - this.height) / 2;
            n9 = 0;
            n8 = this.height;
        } else {
            n10 = 0;
            n9 = (this.height - n) / 2;
            n8 = n;
        }
        if (n2 > this.width) {
            n7 = (n2 - this.width) / 2;
            n6 = 0;
            n5 = this.width;
        } else {
            n7 = 0;
            n6 = (this.width - n2) / 2;
            n5 = n2;
        }
        for (n13 = 0; n13 < n8; ++n13) {
            for (n12 = 0; n12 < n5; ++n12) {
                int n15 = (n6 + n12) * this.channels;
                int n16 = (n7 + n12) * n3;
                if (n3 >= this.channels) {
                    for (n11 = 0; n11 < this.channels; ++n11) {
                        byArray[n10 + n13][n16 + n11] = (byte)(((this.data[n9 + n13][n15 + n11] & 0xFF) * n4 + this.maxval / 2) / this.maxval);
                    }
                    while (n11 < n3) {
                        byArray[n10 + n13][n16 + n11] = byArray[n10 + n13][n16 + this.channels - 1];
                        ++n11;
                    }
                    continue;
                }
                int n17 = 0;
                for (n11 = 0; n11 < n3 - 1; ++n11) {
                    byArray[n10 + n13][n16 + n11] = (byte)(((this.data[n9 + n13][n15 + n11] & 0xFF) * n4 + this.maxval / 2) / this.maxval);
                }
                for (n11 = n3 - 1; n11 < this.channels; ++n11) {
                    n17 += this.data[n9 + n13][n15 + n11] & 0xFF;
                }
                int n18 = this.maxval * (this.channels - n3 + 1);
                byArray[n10 + n13][n16 + n3 - 1] = (byte)((n17 * n4 + n18 / 2) / n18);
            }
        }
        this.height = n;
        this.width = n2;
        this.channels = n3;
        this.maxval = n4;
        this.data = byArray;
    }

    public void scale(int n, int n2) {
        if (n < BlinkenConstants.BlinkenHeightMin) {
            n = BlinkenConstants.BlinkenHeightMin;
        }
        if (n > BlinkenConstants.BlinkenHeightMax) {
            n = BlinkenConstants.BlinkenHeightMax;
        }
        if (n2 < BlinkenConstants.BlinkenWidthMin) {
            n2 = BlinkenConstants.BlinkenWidthMin;
        }
        if (n2 > BlinkenConstants.BlinkenWidthMax) {
            n2 = BlinkenConstants.BlinkenWidthMax;
        }
        if (n == this.height && n2 == this.width) {
            return;
        }
        double d = (double)n2 / (double)this.width;
        double d2 = (double)n / (double)this.height;
        byte[][] byArray = new byte[n][n2 * this.channels];
        for (int i = 0; i < this.channels; ++i) {
            for (int j = 0; j < n; ++j) {
                int n3 = 0;
                int n4 = i;
                while (n3 < n2) {
                    double d3 = (double)j / d2;
                    double d4 = (double)n3 / d;
                    double d5 = (double)(j + 1) / d2 - 1.0E-6;
                    double d6 = (double)(n3 + 1) / d - 1.0E-6;
                    if (d3 < 0.0 || d4 < 0.0 || d5 >= (double)this.height || d6 >= (double)this.width) {
                        byArray[j][n4] = 0;
                    } else {
                        int n5;
                        int n6;
                        double d7;
                        int n7 = (int)d3;
                        int n8 = (int)d4;
                        int n9 = n8 * this.channels + i;
                        int n10 = (int)d5;
                        int n11 = (int)d6;
                        int n12 = n11 * this.channels + i;
                        if (n7 == n10) {
                            if (n8 == n11) {
                                d7 = this.data[n7][n9] & 0xFF;
                            } else {
                                d7 = (double)(this.data[n7][n9] & 0xFF) * (1.0 - d4 + (double)n8) + (double)(this.data[n7][n12] & 0xFF) * (d6 - (double)n11);
                                for (n6 = n9 + this.channels; n6 < n12; n6 += this.channels) {
                                    d7 += (double)(this.data[n7][n6] & 0xFF);
                                }
                                d7 /= d6 - d4;
                            }
                        } else if (n8 == n11) {
                            d7 = (double)(this.data[n7][n9] & 0xFF) * (1.0 - d3 + (double)n7) + (double)(this.data[n10][n9] & 0xFF) * (d5 - (double)n10);
                            for (n5 = n7 + 1; n5 < n10; ++n5) {
                                d7 += (double)(this.data[n5][n9] & 0xFF);
                            }
                            d7 /= d5 - d3;
                        } else {
                            d7 = (double)(this.data[n7][n9] & 0xFF) * (1.0 - d3 + (double)n7) * (1.0 - d4 + (double)n8) + (double)(this.data[n7][n12] & 0xFF) * (1.0 - d3 + (double)n7) * (d6 - (double)n11) + (double)(this.data[n10][n9] & 0xFF) * (d5 - (double)n10) * (1.0 - d4 + (double)n8) + (double)(this.data[n10][n12] & 0xFF) * (d5 - (double)n10) * (d6 - (double)n11);
                            for (n5 = n7 + 1; n5 < n10; ++n5) {
                                d7 += (double)(this.data[n5][n9] & 0xFF) * (1.0 - d4 + (double)n8) + (double)(this.data[n5][n12] & 0xFF) * (d6 - (double)n11);
                            }
                            for (n6 = n9 + this.channels; n6 < n12; n6 += this.channels) {
                                d7 += (double)(this.data[n7][n6] & 0xFF) * (1.0 - d3 + (double)n7) + (double)(this.data[n10][n6] & 0xFF) * (d5 - (double)n10);
                            }
                            for (n5 = n7 + 1; n5 < n10; ++n5) {
                                for (n6 = n9 + this.channels; n6 < n12; n6 += this.channels) {
                                    d7 += (double)(this.data[n5][n6] & 0xFF);
                                }
                            }
                            d7 /= (d5 - d3) * (d6 - d4);
                        }
                        byArray[j][n4] = (byte)(d7 + 0.5);
                    }
                    ++n3;
                    n4 += this.channels;
                }
            }
        }
        this.height = n;
        this.width = n2;
        this.data = byArray;
    }

    public String toString() {
        String string = "";
        for (int i = 0; i < this.height; ++i) {
            int n = 0;
            for (int j = 0; j < this.width; ++j) {
                int n2 = 0;
                n2 = 0;
                int n3 = 0;
                while (n3 < this.channels) {
                    n2 += this.data[i][n] & 0xFF;
                    ++n3;
                    ++n;
                }
                n2 = n2 * 7 / this.maxval / this.channels;
                string = string + " -+*%#&@".substring(n2, n2 + 1);
            }
            string = string + "\n";
        }
        return string + this.duration + " ms\n";
    }

    public byte[] toNetwork(int n) {
        if (n == BlinkenConstants.BlinkenProtoNone) {
            return new byte[0];
        }
        if (n == BlinkenConstants.BlinkenProtoBlp) {
            byte[] byArray = new byte[12 + this.height * this.width];
            byArray[0] = BlinkenProtoBlpMagic[0];
            byArray[1] = BlinkenProtoBlpMagic[1];
            byArray[2] = BlinkenProtoBlpMagic[2];
            byArray[3] = BlinkenProtoBlpMagic[3];
            byArray[4] = 0;
            byArray[5] = 0;
            byArray[6] = 0;
            byArray[7] = 0;
            byArray[8] = (byte)(this.width >> 8 & 0xFF);
            byArray[9] = (byte)(this.width & 0xFF);
            byArray[10] = (byte)(this.height >> 8 & 0xFF);
            byArray[11] = (byte)(this.height & 0xFF);
            int n2 = 12;
            for (int i = 0; i < this.height; ++i) {
                int n3 = 0;
                int n4 = 0;
                while (n3 < this.width) {
                    int n5 = 0;
                    int n6 = 0;
                    while (n6 < this.channels) {
                        n5 += this.data[i][n4] & 0xFF;
                        ++n6;
                        ++n4;
                    }
                    byArray[n2] = (byte)(n5 >= this.channels * this.maxval / 2 ? 1 : 0);
                    ++n3;
                    ++n2;
                }
            }
            return byArray;
        }
        if (n == BlinkenConstants.BlinkenProtoEblp) {
            byte[] byArray = new byte[12 + this.height * this.width];
            byArray[0] = BlinkenProtoEblpMagic[0];
            byArray[1] = BlinkenProtoEblpMagic[1];
            byArray[2] = BlinkenProtoEblpMagic[2];
            byArray[3] = BlinkenProtoEblpMagic[3];
            byArray[4] = 0;
            byArray[5] = 0;
            byArray[6] = 0;
            byArray[7] = 0;
            byArray[8] = (byte)(this.width >> 8 & 0xFF);
            byArray[9] = (byte)(this.width & 0xFF);
            byArray[10] = (byte)(this.height >> 8 & 0xFF);
            byArray[11] = (byte)(this.height & 0xFF);
            int n7 = 12;
            for (int i = 0; i < this.height; ++i) {
                int n8 = 0;
                int n9 = 0;
                while (n8 < this.width) {
                    int n10 = 0;
                    int n11 = 0;
                    while (n11 < this.channels) {
                        n10 += this.data[i][n9] & 0xFF;
                        ++n11;
                        ++n9;
                    }
                    byArray[n7] = (byte)(this.maxval == 255 ? n10 : ((n10 /= this.channels) * 255 + this.maxval / 2) / this.maxval);
                    ++n8;
                    ++n7;
                }
            }
            return byArray;
        }
        if (n == BlinkenConstants.BlinkenProtoMcuf) {
            byte[] byArray = new byte[12 + this.height * this.width * this.channels];
            byArray[0] = BlinkenProtoMcufMagic[0];
            byArray[1] = BlinkenProtoMcufMagic[1];
            byArray[2] = BlinkenProtoMcufMagic[2];
            byArray[3] = BlinkenProtoMcufMagic[3];
            byArray[4] = (byte)(this.height >> 8 & 0xFF);
            byArray[5] = (byte)(this.height & 0xFF);
            byArray[6] = (byte)(this.width >> 8 & 0xFF);
            byArray[7] = (byte)(this.width & 0xFF);
            byArray[8] = (byte)(this.channels >> 8 & 0xFF);
            byArray[9] = (byte)(this.channels & 0xFF);
            byArray[10] = (byte)(this.maxval >> 8 & 0xFF);
            byArray[11] = (byte)(this.maxval & 0xFF);
            int n12 = 12;
            for (int i = 0; i < this.height; ++i) {
                int n13 = 0;
                for (int j = 0; j < this.width; ++j) {
                    int n14 = 0;
                    while (n14 < this.channels) {
                        byArray[n12] = this.data[i][n13];
                        ++n14;
                        ++n12;
                        ++n13;
                    }
                }
            }
            return byArray;
        }
        return new byte[0];
    }

    public int fromNetwork(byte[] byArray) {
        if (byArray.length >= 12 && byArray[0] == BlinkenProtoBlpMagic[0] && byArray[1] == BlinkenProtoBlpMagic[1] && byArray[2] == BlinkenProtoBlpMagic[2] && byArray[3] == BlinkenProtoBlpMagic[3]) {
            int n = (byArray[10] & 0xFF) << 8 | byArray[11] & 0xFF;
            int n2 = (byArray[8] & 0xFF) << 8 | byArray[9] & 0xFF;
            if (byArray.length < 12 + n * n2) {
                return BlinkenConstants.BlinkenProtoNone;
            }
            if (n < BlinkenConstants.BlinkenHeightMin || n > BlinkenConstants.BlinkenHeightMax || n2 < BlinkenConstants.BlinkenWidthMin || n2 > BlinkenConstants.BlinkenWidthMax) {
                return BlinkenConstants.BlinkenProtoNone;
            }
            this.height = n;
            this.width = n2;
            this.channels = 1;
            this.maxval = 1;
            this.duration = BlinkenConstants.BlinkenDurationMin;
            this.data = new byte[this.height][this.width * this.channels];
            int n3 = 12;
            for (int i = 0; i < this.height; ++i) {
                int n4 = 0;
                while (n4 < this.width) {
                    this.data[i][n4] = (byte)(byArray[n3] != 0 ? 1 : 0);
                    ++n4;
                    ++n3;
                }
            }
            return BlinkenConstants.BlinkenProtoBlp;
        }
        if (byArray.length >= 12 && byArray[0] == BlinkenProtoEblpMagic[0] && byArray[1] == BlinkenProtoEblpMagic[1] && byArray[2] == BlinkenProtoEblpMagic[2] && byArray[3] == BlinkenProtoEblpMagic[3]) {
            int n = (byArray[10] & 0xFF) << 8 | byArray[11] & 0xFF;
            int n5 = (byArray[8] & 0xFF) << 8 | byArray[9] & 0xFF;
            if (byArray.length < 12 + n * n5) {
                return BlinkenConstants.BlinkenProtoNone;
            }
            if (n < BlinkenConstants.BlinkenHeightMin || n > BlinkenConstants.BlinkenHeightMax || n5 < BlinkenConstants.BlinkenWidthMin || n5 > BlinkenConstants.BlinkenWidthMax) {
                return BlinkenConstants.BlinkenProtoNone;
            }
            this.height = n;
            this.width = n5;
            this.channels = 1;
            this.maxval = 255;
            this.duration = BlinkenConstants.BlinkenDurationMin;
            this.data = new byte[this.height][this.width * this.channels];
            int n6 = 12;
            for (int i = 0; i < this.height; ++i) {
                int n7 = 0;
                while (n7 < this.width) {
                    this.data[i][n7] = byArray[n6];
                    ++n7;
                    ++n6;
                }
            }
            return BlinkenConstants.BlinkenProtoEblp;
        }
        if (byArray.length >= 12 && byArray[0] == BlinkenProtoMcufMagic[0] && byArray[1] == BlinkenProtoMcufMagic[1] && byArray[2] == BlinkenProtoMcufMagic[2] && byArray[3] == BlinkenProtoMcufMagic[3]) {
            int n = (byArray[4] & 0xFF) << 8 | byArray[5] & 0xFF;
            int n8 = (byArray[6] & 0xFF) << 8 | byArray[7] & 0xFF;
            int n9 = (byArray[8] & 0xFF) << 8 | byArray[9] & 0xFF;
            int n10 = (byArray[10] & 0xFF) << 8 | byArray[11] & 0xFF;
            if (byArray.length < 12 + n * n8 * n9) {
                return BlinkenConstants.BlinkenProtoNone;
            }
            if (n < BlinkenConstants.BlinkenHeightMin || n > BlinkenConstants.BlinkenHeightMax || n8 < BlinkenConstants.BlinkenWidthMin || n8 > BlinkenConstants.BlinkenWidthMax || n9 < BlinkenConstants.BlinkenChannelsMin || n9 > BlinkenConstants.BlinkenChannelsMax || n10 < BlinkenConstants.BlinkenMaxvalMin || n10 > BlinkenConstants.BlinkenMaxvalMax) {
                return BlinkenConstants.BlinkenProtoNone;
            }
            this.height = n;
            this.width = n8;
            this.channels = n9;
            this.maxval = n10;
            this.duration = BlinkenConstants.BlinkenDurationMin;
            this.data = new byte[this.height][this.width * this.channels];
            int n11 = 12;
            for (int i = 0; i < this.height; ++i) {
                int n12 = 0;
                for (int j = 0; j < this.width; ++j) {
                    int n13 = 0;
                    while (n13 < this.channels) {
                        this.data[i][n12] = byArray[n11];
                        ++n13;
                        ++n11;
                        ++n12;
                    }
                }
            }
            return BlinkenConstants.BlinkenProtoMcuf;
        }
        return BlinkenConstants.BlinkenProtoNone;
    }
}

